# 📱 GUÍA COMPLETA: CONVERTIR A APK
## Azuero Safety Services S.A

---

## ✅ PASO 1: GENERAR ICONOS (YA LISTO)

1. Abre el archivo: `icons/generate-icons.html` en tu navegador
2. Se generarán automáticamente todos los iconos
3. Descarga cada uno con su nombre correspondiente
4. Guárdalos en la carpeta `icons/`

**Iconos necesarios:**
- icon-72x72.png
- icon-96x96.png
- icon-128x128.png
- icon-144x144.png
- icon-152x152.png
- icon-192x192.png
- icon-384x384.png
- icon-512x512.png

---

## ✅ PASO 2: PROBAR LA PWA EN PRODUCCIÓN

### A. Subir archivos al servidor

Sube estos archivos NUEVOS a tu servidor:
- `manifest.json`
- `service-worker.js`
- `icons/` (toda la carpeta con los iconos)
- `.well-known/assetlinks.json`

Los archivos PHP ya están actualizados con PWA.

### B. Verificar en el navegador

1. Abre tu web en **Chrome/Edge** en el celular
2. Verás un banner de "Instalar App" en la parte inferior
3. También puedes ir a **Menú → Agregar a pantalla de inicio**

### C. Probar instalación

1. Haz clic en "Instalar"
2. La app se agregará a tu pantalla de inicio
3. Abre desde ahí (funciona como app nativa)

---

## 🚀 PASO 3: CREAR APK PARA PLAY STORE

Hay **3 opciones** para generar la APK:

---

### OPCIÓN 1: PWA BUILDER (MÁS FÁCIL) ⭐ RECOMENDADO

**Ventajas:**
- No necesitas programar
- Genera APK automáticamente
- Gratis y rápido

**Pasos:**

1. Ve a: https://www.pwabuilder.com

2. Ingresa la URL de tu web:
   ```
   https://tudominio.com/panel-simple/
   ```

3. Haz clic en "Start"

4. PWABuilder analizará tu web y te dirá si está lista

5. Haz clic en "Package for Stores" → **Android**

6. Configura:
   - Package ID: `com.azuerosafety.app`
   - App name: `Azuero Safety Services`
   - Version: `1.0.0`
   - Icon: Sube tu icon-512x512.png

7. Haz clic en "Generate" → Descarga el archivo `.aab` o `.apk`

8. Ya tienes tu APK lista para subir a Play Store

---

### OPCIÓN 2: BUBBLEWRAP (LÍNEA DE COMANDOS)

**Requisitos:**
- Node.js instalado
- Android Studio (opcional, para firmar)

**Pasos:**

1. Instala Bubblewrap:
   ```bash
   npm install -g @bubblewrap/cli
   ```

2. Inicializa el proyecto:
   ```bash
   bubblewrap init --manifest https://tudominio.com/panel-simple/manifest.json
   ```

3. Configura cuando te pregunte:
   - Application name: `Azuero Safety Services`
   - Package ID: `com.azuerosafety.app`
   - Start URL: `/panel-simple/`

4. Genera la APK:
   ```bash
   bubblewrap build
   ```

5. La APK estará en: `app-release-signed.apk`

---

### OPCIÓN 3: ANDROID STUDIO (MÁS CONTROL)

**Para desarrolladores avanzados**

1. Instala Android Studio
2. Crea proyecto Android con WebView
3. Configura Trusted Web Activity (TWA)
4. Compila y firma la APK

**Código básico MainActivity.kt:**
```kotlin
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import android.webkit.WebView
import android.webkit.WebSettings

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        
        val webView: WebView = findViewById(R.id.webview)
        webView.settings.javaScriptEnabled = true
        webView.settings.domStorageEnabled = true
        webView.settings.cacheMode = WebSettings.LOAD_DEFAULT
        
        webView.loadUrl("https://tudominio.com/panel-simple/")
    }
}
```

---

## 📦 PASO 4: PUBLICAR EN PLAY STORE

1. **Crear cuenta de desarrollador:**
   - Ve a: https://play.google.com/console
   - Paga $25 USD (pago único de por vida)

2. **Crear nueva aplicación:**
   - Nombre: `Azuero Safety Services`
   - Idioma: Español
   - Tipo: Aplicación
   - Gratis

3. **Completar información:**
   - Descripción corta (80 caracteres)
   - Descripción larga
   - Capturas de pantalla (mínimo 2)
   - Icono de la app (512x512)
   - Banner (1024x500)

4. **Subir APK/AAB:**
   - Ve a "Producción" → "Crear versión"
   - Sube tu archivo `.aab` (recomendado) o `.apk`
   - Versión: 1.0.0

5. **Clasificación de contenido:**
   - Categoría: Utilidades
   - Audiencia: Todas las edades
   - Servicios de emergencia: Sí

6. **Enviar a revisión:**
   - Puede tardar 2-7 días
   - Recibirás email cuando esté aprobada

---

## 🔧 PASO 5: CONFIGURACIÓN ADICIONAL

### A. Editar assetlinks.json

Abre: `.well-known/assetlinks.json`

Reemplaza `https://tudominio.com` con tu dominio real:
```json
[{
  "relation": ["delegate_permission/common.handle_all_urls"],
  "target": {
    "namespace": "web",
    "site": "https://tudominio.com"
  }
}]
```

### B. Verificar HTTPS

Tu web DEBE estar en HTTPS para que PWA funcione.
Si no tienes SSL, contacta a tu proveedor de hosting.

### C. Probar Service Worker

Abre Chrome DevTools (F12) → Application → Service Workers
Deberías ver: "Service Worker registrado"

---

## 🎯 FUNCIONALIDADES DE LA APP

✅ **Lo que YA funciona:**
- Instalable como app nativa
- Icono en pantalla de inicio
- Splash screen personalizado
- Funciona offline (páginas visitadas)
- Notificaciones web
- Acceso a GPS
- Tema personalizado
- Multi-idioma persistente
- Responsive para móviles

✅ **Para ciudadanos:**
- Reportar emergencias médicas
- Reportar emergencias generales
- Ver estado de alertas
- Recibir notificaciones

✅ **Para operadores:**
- Recibir alertas en tiempo real
- Ver ubicación GPS
- Marcar como recibidas
- Dashboard con estadísticas

---

## 🔔 NOTIFICACIONES PUSH (OPCIONAL)

Si quieres notificaciones push reales (como WhatsApp), necesitas:

1. **Firebase Cloud Messaging (FCM)**
   - Crea proyecto en: https://console.firebase.google.com
   - Obtén API Key
   - Configura en service-worker.js

2. **Guardar tokens en BD**
   - Crea tabla: `push_tokens`
   - Guarda token cuando se instale la app

3. **Enviar desde PHP**
   ```php
   // Ejemplo básico
   $url = 'https://fcm.googleapis.com/fcm/send';
   $headers = [
       'Authorization: key=TU_API_KEY',
       'Content-Type: application/json'
   ];
   $data = [
       'to' => $token_usuario,
       'notification' => [
           'title' => 'Nueva Emergencia',
           'body' => 'Alerta médica en tu zona',
           'icon' => '/icons/icon-192x192.png'
       ]
   ];
   // Enviar con cURL
   ```

---

## 📊 ESTADÍSTICAS Y ANALYTICS

Para ver cuántos usuarios instalan la app:

1. **Google Analytics 4**
   - Agrega el código de tracking
   - Ve a: Eventos → app_install

2. **Play Store Console**
   - Estadísticas de descargas
   - Calificaciones y reseñas
   - Crashes y errores

---

## ❓ PREGUNTAS FRECUENTES

**P: ¿Puedo actualizar la app?**
R: Sí, solo actualiza los archivos en tu servidor. La PWA se actualiza automáticamente. Para Play Store, sube nueva versión (1.0.1, 1.0.2, etc.)

**P: ¿Funciona en iOS?**
R: Sí, como PWA (Agregar a pantalla de inicio). Para App Store necesitas Xcode y Mac.

**P: ¿Necesito cambiar algo del código PHP?**
R: No, todo funciona igual. Solo agregamos PWA encima.

**P: ¿Los usuarios actuales pierden sus datos?**
R: No, todo sigue igual. Es la misma web con funcionalidad de app.

**P: ¿Cuánto cuesta?**
R: PWA es gratis. Play Store = $25 USD (pago único).

---

## 🆘 SOPORTE

Si tienes problemas:

1. Revisa Chrome DevTools → Console (errores JS)
2. Verifica que manifest.json sea accesible
3. Confirma que service-worker.js esté registrado
4. Asegúrate de tener HTTPS activo
5. Prueba en modo incógnito

---

## 🎉 ¡LISTO!

Ahora tienes una Progressive Web App completamente funcional que:
- Se instala como app nativa
- Funciona offline
- Envía notificaciones
- Está lista para Play Store

**Siguiente paso:** Genera los iconos y prueba la instalación desde tu celular.

---

**Creado para:** Azuero Safety Services S.A
**Somos tu seguridad** 🛡️
