-- ============================================
-- MIGRACIÓN COMPLETA: SISTEMA DE LOGIN UNIFICADO
-- ============================================
-- Ejecuta este script en phpMyAdmin de tu hosting
-- Base de datos: u793455123_azuero_safety
-- NOTA: Algunas líneas pueden dar error si la columna ya existe, es normal.
-- ============================================

USE u793455123_azuero_safety;

-- Paso 1: Agregar columna username (CRÍTICO)
-- Si da error "columna duplicada", ignóralo y continúa
ALTER TABLE users ADD COLUMN username VARCHAR(50) UNIQUE AFTER id;

-- Paso 2: Agregar columna password (CRÍTICO)
-- Si da error "columna duplicada", ignóralo y continúa
ALTER TABLE users ADD COLUMN password VARCHAR(255) AFTER username;

-- Paso 3: Agregar emergency_contact_name
-- Si da error "columna duplicada", ignóralo
ALTER TABLE users ADD COLUMN emergency_contact_name VARCHAR(100) AFTER medical_conditions;

-- Paso 4: Agregar emergency_contact_relation
-- Si da error "columna duplicada", ignóralo
ALTER TABLE users ADD COLUMN emergency_contact_relation VARCHAR(50) AFTER emergency_contact_phone;

-- Paso 5: Agregar medications
-- Si da error "columna duplicada", ignóralo
ALTER TABLE users ADD COLUMN medications TEXT AFTER medical_conditions;

-- Paso 6: Agregar service_code
-- Si da error "columna duplicada", ignóralo
ALTER TABLE users ADD COLUMN service_code VARCHAR(12) UNIQUE NULL AFTER cedula;

-- Paso 7: Actualizar usuarios existentes para que tengan username
UPDATE users 
SET username = CONCAT('user', id) 
WHERE username IS NULL OR username = '';

-- Paso 8: Actualizar usuarios existentes con password temporal
-- Password: "temporal123"
UPDATE users 
SET password = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'
WHERE password IS NULL OR password = '';

-- Verificación final
SELECT 'Migración completada' as mensaje;
SELECT username, full_name, email, 
       CASE WHEN password IS NULL THEN 'SIN PASSWORD' ELSE 'OK' END as password_status
FROM users;
