-- ============================================
-- MIGRACIÓN FINAL: Solo columnas faltantes
-- ============================================
-- Base de datos: u793455123_azuero_safety
-- ============================================

USE u793455123_azuero_safety;

-- SOLO agregar username y password si no existen
-- Si dan error "columna duplicada", IGNORAR y continuar

-- Agregar username
ALTER TABLE users ADD COLUMN username VARCHAR(50) UNIQUE AFTER id;

-- Agregar password
ALTER TABLE users ADD COLUMN password VARCHAR(255) AFTER username;

-- Actualizar usuarios existentes con username
UPDATE users 
SET username = CONCAT('user', id) 
WHERE username IS NULL OR username = '';

-- Actualizar usuarios existentes con password temporal: "temporal123"
UPDATE users 
SET password = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'
WHERE password IS NULL OR password = '';

-- Verificar
SELECT username, full_name, email, 
       CASE WHEN password IS NULL THEN 'SIN PASSWORD' ELSE 'OK' END as password_status
FROM users;
