-- ============================================
-- MIGRACIÓN: SISTEMA DE LOGIN UNIFICADO
-- ============================================
-- Este script actualiza la base de datos para permitir
-- que tanto operadores como ciudadanos inicien sesión
-- con usuario y contraseña desde el mismo formulario.
-- El administrador creará TODAS las cuentas.
-- ============================================

USE azuero_safety;

-- Agregar campos de autenticación a la tabla users
ALTER TABLE users 
ADD COLUMN username VARCHAR(50) UNIQUE NOT NULL AFTER id,
ADD COLUMN password VARCHAR(255) NOT NULL AFTER username;

-- Hacer que service_code sea opcional (ya no se usa para login)
-- Se puede mantener como ID de ciudadano si se desea
ALTER TABLE users 
MODIFY service_code VARCHAR(12) UNIQUE NULL;

-- Agregar índice para búsquedas rápidas de username
CREATE INDEX idx_users_username ON users(username);

-- Actualizar usuarios existentes (si los hay)
-- Generar usernames temporales basados en el ID
UPDATE users 
SET username = CONCAT('ciudadano', id) 
WHERE username IS NULL OR username = '';

-- Generar contraseñas temporales (hash de "temporal123")
-- Los usuarios deberán cambiarla en su primer acceso
UPDATE users 
SET password = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'
WHERE password IS NULL OR password = '';

-- Opcional: Eliminar la tabla service_codes si ya no se usa
-- DROP TABLE IF EXISTS service_codes;

-- Verificar los cambios
SELECT 'Estructura actualizada correctamente' as mensaje;
SELECT COUNT(*) as total_usuarios FROM users;
SELECT COUNT(*) as total_operadores FROM operators;

-- ============================================
-- NOTAS IMPORTANTES:
-- ============================================
-- 1. Todos los usuarios existentes ahora tienen:
--    Username: ciudadano1, ciudadano2, etc.
--    Password temporal: "temporal123"
--
-- 2. El administrador debe:
--    - Cambiar las contraseñas de usuarios existentes
--    - Crear nuevas cuentas desde la interfaz de administración
--
-- 3. Los ciudadanos nuevos en su primer login serán
--    redirigidos a completar-perfil.php para ingresar
--    su información médica y de contacto de emergencia.
--
-- 4. La tabla service_codes puede eliminarse si ya no
--    se necesita para ningún propósito.
-- ============================================
