<?php
require_once 'config.php';

// Verificar que sea un ciudadano logueado
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'citizen') {
    header('Location: index.php');
    exit;
}

$lang = $_SESSION['lang'] ?? 'es';

$translations = [
    'es' => [
        'title' => 'Mi Perfil',
        'back' => 'Volver al Panel',
        'personal' => 'Información Personal',
        'medical' => 'Información Médica',
        'emergency_contact' => 'Contacto de Emergencia',
        'full_name' => 'Nombre Completo',
        'email' => 'Correo Electrónico',
        'phone' => 'Teléfono',
        'cedula' => 'Cédula',
        'blood_type' => 'Tipo de Sangre',
        'allergies' => 'Alergias',
        'conditions' => 'Condiciones Médicas',
        'medications' => 'Medicamentos',
        'contact_name' => 'Nombre del Contacto',
        'contact_phone' => 'Teléfono del Contacto',
        'contact_relation' => 'Relación',
        'update' => 'Actualizar Información',
        'success' => 'Perfil actualizado correctamente',
        'error' => 'Error al actualizar perfil',
        'service_code' => 'Código de Servicio',
        'status' => 'Estado',
        'active' => 'Activo',
        'none' => 'Ninguna',
        'not_specified' => 'No especificado'
    ],
    'en' => [
        'title' => 'My Profile',
        'back' => 'Back to Panel',
        'personal' => 'Personal Information',
        'medical' => 'Medical Information',
        'emergency_contact' => 'Emergency Contact',
        'full_name' => 'Full Name',
        'email' => 'Email',
        'phone' => 'Phone',
        'cedula' => 'ID Number',
        'blood_type' => 'Blood Type',
        'allergies' => 'Allergies',
        'conditions' => 'Medical Conditions',
        'medications' => 'Medications',
        'contact_name' => 'Contact Name',
        'contact_phone' => 'Contact Phone',
        'contact_relation' => 'Relationship',
        'update' => 'Update Information',
        'success' => 'Profile updated successfully',
        'error' => 'Error updating profile',
        'service_code' => 'Service Code',
        'status' => 'Status',
        'active' => 'Active',
        'none' => 'None',
        'not_specified' => 'Not specified'
    ]
];

$t = $translations[$lang];
$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $stmt = $conn->prepare("
            UPDATE users SET 
                full_name = ?,
                email = ?,
                phone = ?,
                blood_type = ?,
                allergies = ?,
                medical_conditions = ?,
                current_medications = ?,
                emergency_contact_name = ?,
                emergency_contact_phone = ?,
                emergency_contact_relation = ?
            WHERE id = ?
        ");
        
        $stmt->execute([
            $_POST['full_name'],
            $_POST['email'],
            $_POST['phone'],
            $_POST['blood_type'],
            $_POST['allergies'],
            $_POST['medical_conditions'],
            $_POST['current_medications'],
            $_POST['emergency_contact_name'],
            $_POST['emergency_contact_phone'],
            $_POST['emergency_contact_relation'],
            $_SESSION['user_id']
        ]);
        
        $message = '<div class="alert alert-success">' . $t['success'] . '</div>';
        $_SESSION['full_name'] = $_POST['full_name'];
    } catch(PDOException $e) {
        $message = '<div class="alert alert-error">' . $t['error'] . '</div>';
    }
}

$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['title']; ?> - Azuero Safety</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a237e 0%, #283593 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
        }
        .header {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .title { font-size: 24px; color: #1976d2; font-weight: bold; }
        .btn-back { background: #1976d2; color: white; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 600; }
        .btn-back:hover { background: #1565c0; }
        
        .profile-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.2);
            margin-bottom: 20px;
        }
        .section-title {
            font-size: 20px;
            font-weight: bold;
            color: #1976d2;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e0e0e0;
        }
        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: 600; margin-bottom: 8px; color: #333; font-size: 14px; }
        .form-group input, .form-group select, .form-group textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        .form-group input:focus, .form-group select:focus, .form-group textarea:focus {
            outline: none;
            border-color: #1976d2;
        }
        .form-group textarea { min-height: 80px; resize: vertical; }
        .form-group input[readonly] {
            background: #f5f5f5;
            cursor: not-allowed;
            color: #666;
        }
        .btn-submit {
            width: 100%;
            padding: 14px;
            background: #2e7d32;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }
        .btn-submit:hover { background: #388e3c; }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 600;
            text-align: center;
        }
        .alert-success { background: #e8f5e9; color: #2e7d32; }
        .alert-error { background: #ffebee; color: #c62828; }
        .info-badge {
            display: inline-block;
            background: #e3f2fd;
            color: #1976d2;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="title">👤 <?php echo $t['title']; ?></div>
            <a href="panel-ciudadano.php" class="btn-back">← <?php echo $t['back']; ?></a>
        </div>
        
        <?php echo $message; ?>
        
        <form method="POST">
            <div class="profile-card">
                <div class="section-title">📋 <?php echo $t['personal']; ?></div>
                
                <div class="form-group">
                    <label><?php echo $t['service_code']; ?></label>
                    <input type="text" value="<?php echo htmlspecialchars($user['service_code']); ?>" readonly>
                    <span class="info-badge"><?php echo $t['active']; ?> ✓</span>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label><?php echo $t['full_name']; ?></label>
                        <input type="text" name="full_name" value="<?php echo htmlspecialchars($user['full_name']); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label><?php echo $t['cedula']; ?></label>
                        <input type="text" value="<?php echo htmlspecialchars($user['cedula']); ?>" readonly>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>📧 <?php echo $t['email']; ?></label>
                        <input type="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>📱 <?php echo $t['phone']; ?></label>
                        <input type="tel" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required>
                    </div>
                </div>
            </div>
            
            <div class="profile-card">
                <div class="section-title">🏥 <?php echo $t['medical']; ?></div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>🩸 <?php echo $t['blood_type']; ?></label>
                        <select name="blood_type">
                            <option value="">-- <?php echo $t['not_specified']; ?> --</option>
                            <?php
                            $blood_types = ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'];
                            foreach ($blood_types as $type) {
                                $selected = $user['blood_type'] == $type ? 'selected' : '';
                                echo "<option value=\"$type\" $selected>$type</option>";
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>⚠️ <?php echo $t['allergies']; ?></label>
                        <input type="text" name="allergies" value="<?php echo htmlspecialchars($user['allergies'] ?: $t['none']); ?>">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>🩺 <?php echo $t['conditions']; ?></label>
                    <textarea name="medical_conditions"><?php echo htmlspecialchars($user['medical_conditions'] ?: $t['none']); ?></textarea>
                </div>
                
                <div class="form-group">
                    <label>💊 <?php echo $t['medications']; ?></label>
                    <textarea name="current_medications"><?php echo htmlspecialchars($user['current_medications'] ?: $t['none']); ?></textarea>
                </div>
            </div>
            
            <div class="profile-card">
                <div class="section-title">📞 <?php echo $t['emergency_contact']; ?></div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label><?php echo $t['contact_name']; ?></label>
                        <input type="text" name="emergency_contact_name" value="<?php echo htmlspecialchars($user['emergency_contact_name']); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label><?php echo $t['contact_phone']; ?></label>
                        <input type="tel" name="emergency_contact_phone" value="<?php echo htmlspecialchars($user['emergency_contact_phone']); ?>" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label><?php echo $t['contact_relation']; ?></label>
                    <input type="text" name="emergency_contact_relation" value="<?php echo htmlspecialchars($user['emergency_contact_relation']); ?>" required>
                </div>
            </div>
            
            <button type="submit" class="btn-submit">💾 <?php echo $t['update']; ?></button>
        </form>
    </div>
</body>
</html>
