<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config.php';

echo "<h2>🔍 Debug de Login</h2>";
echo "<hr>";

// Test de credenciales
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');
    
    echo "<h3>📝 Datos Recibidos:</h3>";
    echo "Usuario: <strong>" . htmlspecialchars($username) . "</strong><br>";
    echo "Password: <strong>" . str_repeat('*', strlen($password)) . "</strong><br>";
    echo "<hr>";
    
    try {
        echo "<h3>🔎 Buscando en operadores...</h3>";
        $stmt = $conn->prepare("
            SELECT 
                id,
                username,
                full_name,
                email,
                role,
                status,
                password as pwd_hash
            FROM operators 
            WHERE (username = ? OR email = ?)
        ");
        $stmt->execute([$username, $username]);
        $operator = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($operator) {
            echo "✅ Operador encontrado:<br>";
            echo "<pre style='background:#f5f5f5;padding:10px;'>";
            echo "ID: " . $operator['id'] . "\n";
            echo "Username: " . $operator['username'] . "\n";
            echo "Nombre: " . $operator['full_name'] . "\n";
            echo "Email: " . $operator['email'] . "\n";
            echo "Rol: " . $operator['role'] . "\n";
            echo "Estado: " . $operator['status'] . "\n";
            echo "Hash: " . substr($operator['pwd_hash'], 0, 30) . "...\n";
            echo "</pre>";
            
            if (password_verify($password, $operator['pwd_hash'])) {
                echo "✅ <strong style='color:green;'>¡Contraseña correcta!</strong><br>";
                echo "<br>🎯 <strong>Este usuario debería redirigirse a:</strong> ";
                if ($operator['role'] === 'admin') {
                    echo "<a href='admin-panel.php'>admin-panel.php</a><br>";
                } else {
                    echo "<a href='dashboard.php'>dashboard.php</a><br>";
                }
                
                if ($operator['status'] !== 'active') {
                    echo "<br>⚠️ <strong style='color:red;'>PROBLEMA: Estado es '{$operator['status']}' pero debe ser 'active'</strong><br>";
                }
            } else {
                echo "❌ <strong style='color:red;'>Contraseña incorrecta</strong><br>";
                echo "<br>💡 Para resetear la contraseña, ejecuta en phpMyAdmin:<br>";
                $newHash = password_hash($password, PASSWORD_DEFAULT);
                echo "<textarea style='width:100%;height:60px;font-family:monospace;font-size:11px;'>";
                echo "UPDATE operators SET password = '{$newHash}' WHERE id = {$operator['id']};";
                echo "</textarea>";
            }
        } else {
            echo "❌ No se encontró operador con username o email = '{$username}'<br>";
            
            // Mostrar todos los operadores
            echo "<h4>📋 Operadores disponibles:</h4>";
            $stmt = $conn->query("SELECT id, username, email, role, status FROM operators");
            $all_ops = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo "<table border='1' cellpadding='5' style='border-collapse:collapse;'>";
            echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Rol</th><th>Estado</th></tr>";
            foreach ($all_ops as $op) {
                echo "<tr>";
                echo "<td>{$op['id']}</td>";
                echo "<td>{$op['username']}</td>";
                echo "<td>{$op['email']}</td>";
                echo "<td>{$op['role']}</td>";
                echo "<td>{$op['status']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
    } catch (PDOException $e) {
        echo "<div style='background:#ffebee;color:#c62828;padding:15px;border-radius:8px;'>";
        echo "❌ Error SQL: " . $e->getMessage();
        echo "</div>";
    }
    
    echo "<hr>";
    echo "<a href='debug-login.php'>← Probar otro usuario</a>";
    
} else {
    // Mostrar formulario
    ?>
    <h3>🔐 Formulario de Prueba</h3>
    <form method="POST" action="">
        <div style="margin-bottom:15px;">
            <label style="display:block;margin-bottom:5px;"><strong>Usuario o Email:</strong></label>
            <input type="text" name="username" required style="padding:8px;width:300px;border:1px solid #ccc;">
        </div>
        <div style="margin-bottom:15px;">
            <label style="display:block;margin-bottom:5px;"><strong>Contraseña:</strong></label>
            <input type="password" name="password" required style="padding:8px;width:300px;border:1px solid #ccc;">
        </div>
        <button type="submit" style="padding:10px 20px;background:#1e3c72;color:white;border:none;cursor:pointer;border-radius:5px;">
            🔍 Probar Login
        </button>
    </form>
    
    <hr>
    <h3>💡 Sugerencias:</h3>
    <ul>
        <li>Prueba con <code>admin</code> como usuario</li>
        <li>O prueba con el email del operador</li>
        <li>Si no funciona, verifica la contraseña</li>
    </ul>
    <?php
}
?>

<style>
    body { 
        font-family: Arial, sans-serif; 
        max-width: 900px; 
        margin: 50px auto; 
        padding: 20px;
        background: #f5f5f5;
    }
    h2 { color: #1e3c72; }
    h3 { color: #2a5298; margin-top: 20px; }
    hr { margin: 30px 0; }
    code {
        background: #fff3cd;
        padding: 2px 6px;
        border-radius: 3px;
        font-family: monospace;
    }
    pre {
        background: #f5f5f5;
        padding: 10px;
        border-radius: 5px;
        border-left: 3px solid #1e3c72;
    }
    table {
        background: white;
        margin-top: 10px;
    }
    a {
        color: #1e3c72;
        text-decoration: none;
        font-weight: bold;
    }
    a:hover {
        text-decoration: underline;
    }
</style>
