<?php
require_once 'config.php';
header('Content-Type: application/json');

// Verificar que sea un operador logueado
if (!isset($_SESSION['operator_id'])) {
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

$alert_id = $_POST['alert_id'] ?? 0;

if (!$alert_id) {
    echo json_encode(['error' => 'ID de alerta no proporcionado']);
    exit;
}

try {
    // Verificar si la alerta ya fue marcada como recibida
    $stmt = $conn->prepare("SELECT received_at, status FROM alerts WHERE id = ?");
    $stmt->execute([$alert_id]);
    $alert = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$alert) {
        echo json_encode(['error' => 'Alerta no encontrada']);
        exit;
    }
    
    // Solo actualizar si aún no ha sido marcada como recibida
    if (!$alert['received_at']) {
        $stmt = $conn->prepare("
            UPDATE alerts 
            SET received_at = NOW(), 
                received_by_operator_id = ?,
                updated_at = NOW() 
            WHERE id = ?
        ");
        $stmt->execute([$_SESSION['operator_id'], $alert_id]);
        
        echo json_encode([
            'success' => true,
            'message' => 'Alerta marcada como recibida',
            'received_at' => date('Y-m-d H:i:s')
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'message' => 'Alerta ya había sido recibida',
            'already_received' => true
        ]);
    }
    
} catch(PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
