<?php
require_once 'config.php';

// Verificar sesión y permisos de admin
if (!isset($_SESSION['operator_id'])) {
    header('Location: index.php');
    exit;
}

// Obtener información del operador
try {
    $stmt = $conn->prepare("SELECT * FROM operators WHERE id = ?");
    $stmt->execute([$_SESSION['operator_id']]);
    $operator = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$operator || $operator['role'] !== 'admin') {
        header('Location: dashboard.php');
        exit;
    }
} catch (PDOException $e) {
    die("Error");
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Usuarios - Emergency Saver</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #667eea;
            --primary-dark: #5568d3;
            --secondary: #764ba2;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --info: #3b82f6;
            --bg-primary: #ffffff;
            --bg-secondary: #f8fafc;
            --bg-card: #ffffff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --border-color: #e2e8f0;
            --shadow-sm: 0 1px 3px rgba(0,0,0,0.1);
            --shadow-md: 0 4px 6px rgba(0,0,0,0.1);
            --shadow-lg: 0 10px 25px rgba(0,0,0,0.15);
            --sidebar-width: 280px;
        }

        [data-theme="dark"] {
            --primary: #818cf8;
            --primary-dark: #6366f1;
            --bg-primary: #0f172a;
            --bg-secondary: #1e293b;
            --bg-card: #1e293b;
            --text-primary: #f1f5f9;
            --text-secondary: #94a3b8;
            --border-color: #334155;
        }

        [data-theme="blue-dark"] {
            --primary: #60a5fa;
            --primary-dark: #3b82f6;
            --secondary: #06b6d4;
            --bg-primary: #0c1e35;
            --bg-secondary: #1a2942;
            --bg-card: #1a2942;
            --text-primary: #e0f2fe;
            --text-secondary: #7dd3fc;
            --border-color: #1e3a5f;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-primary);
            color: var(--text-primary);
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            width: var(--sidebar-width);
            background: var(--bg-card);
            border-right: 1px solid var(--border-color);
            box-shadow: var(--shadow-md);
            z-index: 1000;
            overflow-y: auto;
        }

        .sidebar-header {
            padding: 30px 20px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            text-align: center;
        }

        .sidebar-header h2 {
            font-size: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .sidebar-menu {
            padding: 20px 0;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 15px 25px;
            color: var(--text-primary);
            text-decoration: none;
            transition: all 0.3s ease;
            border-left: 3px solid transparent;
        }

        .menu-item:hover {
            background: var(--bg-secondary);
            border-left-color: var(--primary);
            color: var(--primary);
        }

        .menu-item i {
            width: 24px;
            font-size: 20px;
            margin-right: 15px;
        }

        .menu-section {
            padding: 10px 25px;
            font-size: 12px;
            font-weight: 600;
            color: var(--text-secondary);
            text-transform: uppercase;
            margin-top: 20px;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
        }

        /* Header */
        .header {
            background: var(--bg-card);
            border-bottom: 1px solid var(--border-color);
            padding: 20px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: var(--shadow-sm);
            position: sticky;
            top: 0;
            z-index: 999;
        }

        .header-left h1 {
            font-size: 28px;
            color: var(--text-primary);
        }

        .breadcrumb {
            color: var(--text-secondary);
            font-size: 14px;
            margin-top: 5px;
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .theme-switcher {
            display: flex;
            gap: 10px;
            background: var(--bg-secondary);
            padding: 5px;
            border-radius: 25px;
        }

        .theme-btn {
            padding: 8px 15px;
            border: none;
            background: transparent;
            color: var(--text-secondary);
            cursor: pointer;
            border-radius: 20px;
            font-size: 13px;
            transition: all 0.3s ease;
        }

        .theme-btn.active {
            background: var(--primary);
            color: white;
        }

        /* Content */
        .content {
            padding: 30px;
        }

        .info-banner {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            text-align: center;
        }

        .info-banner h2 {
            font-size: 24px;
            margin-bottom: 10px;
        }

        .info-banner p {
            font-size: 16px;
            opacity: 0.9;
        }

        .info-banner .btn {
            margin-top: 20px;
            background: white;
            color: var(--primary);
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }

        .info-banner .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }

        .feature-card {
            background: var(--bg-card);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            transition: all 0.3s ease;
        }

        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-lg);
        }

        .feature-icon {
            width: 70px;
            height: 70px;
            margin: 0 auto 20px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 32px;
            color: white;
        }

        .feature-icon.blue { background: linear-gradient(135deg, #667eea, #764ba2); }
        .feature-icon.green { background: linear-gradient(135deg, #10b981, #059669); }
        .feature-icon.orange { background: linear-gradient(135deg, #f59e0b, #d97706); }

        .feature-card h3 {
            font-size: 20px;
            margin-bottom: 10px;
            color: var(--text-primary);
        }

        .feature-card p {
            color: var(--text-secondary);
            line-height: 1.6;
        }

        @media (max-width: 1024px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>
<body data-theme="light">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h2>
                <i class="fas fa-shield-alt"></i>
                Emergency Saver
            </h2>
        </div>

        <div class="sidebar-menu">
            <a href="dashboard.php" class="menu-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>

            <div class="menu-section">Alertas</div>
            
            <a href="alertas.php" class="menu-item">
                <i class="fas fa-bell"></i>
                <span>Todas las Alertas</span>
            </a>

            <div class="menu-section">Administración</div>
            
            <a href="admin-panel.php" class="menu-item">
                <i class="fas fa-user-shield"></i>
                <span>Panel Admin</span>
            </a>

            <a href="operadores.php" class="menu-item" style="border-left-color: var(--primary); background: var(--bg-secondary); color: var(--primary);">
                <i class="fas fa-users"></i>
                <span>Gestión de Usuarios</span>
            </a>

            <div class="menu-section">Sistema</div>

            <a href="logout.php" class="menu-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Cerrar Sesión</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                <h1>Gestión de Usuarios</h1>
                <div class="breadcrumb">
                    <a href="dashboard.php" style="color: var(--text-secondary); text-decoration: none;"><i class="fas fa-home"></i></a> / 
                    Gestión de Usuarios
                </div>
            </div>

            <div class="header-right">
                <div class="theme-switcher">
                    <button class="theme-btn active" data-theme="light" onclick="changeTheme('light')">☀️</button>
                    <button class="theme-btn" data-theme="dark" onclick="changeTheme('dark')">🌙</button>
                    <button class="theme-btn" data-theme="blue-dark" onclick="changeTheme('blue-dark')">🌊</button>
                </div>
            </div>
        </div>

        <!-- Content -->
        <div class="content">
            <!-- Info Banner -->
            <div class="info-banner">
                <h2><i class="fas fa-info-circle"></i> Gestión Completa de Usuarios</h2>
                <p>Administra todos los usuarios y operadores del sistema desde el Panel de Administración</p>
                <a href="admin-panel.php" class="btn">
                    <i class="fas fa-arrow-right"></i> Ir al Panel Admin
                </a>
            </div>

            <!-- Features Grid -->
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon blue">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>Gestión de Ciudadanos</h3>
                    <p>Crea, edita y administra cuentas de ciudadanos. Visualiza su historial de alertas y estadísticas.</p>
                </div>

                <div class="feature-card">
                    <div class="feature-icon green">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <h3>Gestión de Operadores</h3>
                    <p>Administra operadores del sistema, asigna roles (admin/operador) y controla permisos de acceso.</p>
                </div>

                <div class="feature-card">
                    <div class="feature-icon orange">
                        <i class="fas fa-key"></i>
                    </div>
                    <h3>Reseteo de Contraseñas</h3>
                    <p>Genera contraseñas temporales de forma segura para usuarios y operadores que lo necesiten.</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        function changeTheme(theme) {
            document.body.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            
            document.querySelectorAll('.theme-btn').forEach(btn => {
                btn.classList.remove('active');
                if(btn.getAttribute('data-theme') === theme) {
                    btn.classList.add('active');
                }
            });
        }

        const savedTheme = localStorage.getItem('theme') || 'light';
        changeTheme(savedTheme);
    </script>
</body>
</html>
