<?php
require_once 'config.php';
header('Content-Type: application/json');

// Log de debugging
error_log("=== NUEVA PETICIÓN ALERTA ===");
error_log("Timestamp: " . date('Y-m-d H:i:s'));
error_log("User ID: " . ($_SESSION['user_id'] ?? 'NO SESSION'));
error_log("POST data: " . json_encode($_POST));
error_log("=============================");

// Verificar que sea un ciudadano logueado
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'citizen') {
    echo json_encode(['success' => false, 'error' => 'No autorizado']);
    exit;
}

$type = $_POST['type'] ?? '';
$latitude = $_POST['latitude'] ?? null;
$longitude = $_POST['longitude'] ?? null;
$description = $_POST['description'] ?? '';
$emergency_type = $_POST['emergency_type'] ?? '';
$is_immediate = $_POST['is_immediate'] ?? '0';
$timestamp = $_POST['timestamp'] ?? null;

// Prevenir duplicados: verificar si ya existe una alerta con el mismo timestamp en los últimos 5 segundos
if ($timestamp && $type == 'medical') {
    $stmt = $conn->prepare("
        SELECT id FROM alerts 
        WHERE user_id = ? 
        AND alert_type = 'medical' 
        AND created_at >= DATE_SUB(NOW(), INTERVAL 5 SECOND)
        LIMIT 1
    ");
    $stmt->execute([$_SESSION['user_id']]);
    if ($stmt->fetch()) {
        error_log("ALERTA DUPLICADA DETECTADA - Bloqueando");
        echo json_encode(['success' => false, 'error' => 'Duplicate alert detected']);
        exit;
    }
}

try {
    if ($type == 'medical') {
        $stmt = $conn->prepare("
            INSERT INTO alerts (user_id, alert_type, priority, status, latitude, longitude, description, created_at) 
            VALUES (?, 'medical', 'high', 'pending', ?, ?, 'EMERGENCIA MÉDICA - Situación crítica de vida o muerte', NOW())
        ");
        $stmt->execute([
            $_SESSION['user_id'],
            $latitude ?: null,
            $longitude ?: null
        ]);
        
        $alert_id = $conn->lastInsertId();
        error_log("ALERTA MÉDICA CREADA - ID: " . $alert_id);
        
    } elseif ($type == 'general') {
        $priority = 'medium';
        if ($emergency_type == 'fire') $priority = 'high';
        
        $alert_type_map = [
            'fire' => 'fire',
            'accident' => 'accident',
            'rescue' => 'other',
            'other' => 'other'
        ];
        
        $stmt = $conn->prepare("
            INSERT INTO alerts (user_id, alert_type, priority, status, latitude, longitude, description, created_at) 
            VALUES (?, ?, ?, 'pending', ?, ?, ?, NOW())
        ");
        $stmt->execute([
            $_SESSION['user_id'],
            $alert_type_map[$emergency_type] ?? 'other',
            $priority,
            $latitude ?: null,
            $longitude ?: null,
            $description
        ]);
        
    } elseif ($type == 'police') {
        $priority = $is_immediate == '1' ? 'high' : 'medium';
        $desc = $is_immediate == '1' ? 'EMERGENCIA POLICIAL INMEDIATA' : $description;
        
        $stmt = $conn->prepare("
            INSERT INTO alerts (user_id, alert_type, priority, status, latitude, longitude, description, created_at) 
            VALUES (?, 'police', ?, 'pending', ?, ?, ?, NOW())
        ");
        $stmt->execute([
            $_SESSION['user_id'],
            $priority,
            $latitude ?: null,
            $longitude ?: null,
            $desc
        ]);
    } else {
        throw new Exception('Tipo de alerta inválido');
    }
    
    echo json_encode(['success' => true, 'alert_id' => $conn->lastInsertId()]);
    
} catch(Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
