<?php
// Activar errores para depuración
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔍 Test de Admin Panel</h2>";
echo "<hr>";

echo "<h3>1️⃣ Verificando config.php...</h3>";
try {
    require_once 'config.php';
    echo "✅ config.php cargado<br>";
    echo "✅ Conexión a BD: OK<br>";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    exit;
}

echo "<h3>2️⃣ Verificando sesión...</h3>";
if (isset($_SESSION['operator_id'])) {
    echo "✅ operator_id en sesión: " . $_SESSION['operator_id'] . "<br>";
} else {
    echo "❌ No hay operator_id en sesión<br>";
    echo "➡️ <a href='index.php'>Ir al login</a><br>";
}

echo "<h3>3️⃣ Verificando operador en BD...</h3>";
if (isset($_SESSION['operator_id'])) {
    try {
        $stmt = $conn->prepare("SELECT * FROM operators WHERE id = ?");
        $stmt->execute([$_SESSION['operator_id']]);
        $operator = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($operator) {
            echo "✅ Operador encontrado:<br>";
            echo "<pre style='background:#f5f5f5;padding:10px;'>";
            echo "ID: " . $operator['id'] . "\n";
            echo "Username: " . ($operator['username'] ?? 'N/A') . "\n";
            echo "Nombre: " . ($operator['full_name'] ?? 'N/A') . "\n";
            echo "Email: " . ($operator['email'] ?? 'N/A') . "\n";
            echo "Rol: " . ($operator['role'] ?? 'N/A') . "\n";
            echo "</pre>";
        } else {
            echo "❌ Operador no encontrado con ID: " . $_SESSION['operator_id'] . "<br>";
        }
    } catch (PDOException $e) {
        echo "❌ Error SQL: " . $e->getMessage() . "<br>";
    }
}

echo "<h3>4️⃣ Verificando tablas necesarias...</h3>";
$tables = ['operators', 'users', 'alerts'];
foreach ($tables as $table) {
    try {
        $stmt = $conn->query("SELECT COUNT(*) as count FROM $table");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "✅ Tabla '$table': {$result['count']} registros<br>";
    } catch (PDOException $e) {
        echo "❌ Error con tabla '$table': " . $e->getMessage() . "<br>";
    }
}

echo "<h3>5️⃣ Verificando columnas de operators...</h3>";
try {
    $stmt = $conn->query("SHOW COLUMNS FROM operators");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='5' style='border-collapse:collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th></tr>";
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Verificar columnas críticas
    $requiredColumns = ['id', 'username', 'full_name', 'email', 'password', 'role', 'status'];
    $existingColumns = array_column($columns, 'Field');
    
    echo "<br><h4>Columnas requeridas:</h4>";
    foreach ($requiredColumns as $col) {
        if (in_array($col, $existingColumns)) {
            echo "✅ $col<br>";
        } else {
            echo "❌ $col <strong style='color:red;'>(FALTA)</strong><br>";
        }
    }
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

echo "<hr>";
echo "<h3>6️⃣ Probando admin-panel.php...</h3>";
if (isset($_SESSION['operator_id']) && $operator) {
    echo "✅ Todo listo. Probando cargar admin-panel...<br><br>";
    echo "<a href='admin-panel.php' style='padding:10px 20px;background:#1e3c72;color:white;text-decoration:none;border-radius:5px;'>🚀 Ir a Admin Panel</a>";
} else {
    echo "⚠️ Primero debes iniciar sesión<br>";
    echo "<a href='index.php' style='padding:10px 20px;background:#1e3c72;color:white;text-decoration:none;border-radius:5px;'>🔐 Ir al Login</a>";
}

echo "<br><br>";
echo "<h3>💡 Si hay columnas faltantes:</h3>";
echo "<a href='migrate-database.php' style='padding:10px 20px;background:#f57c00;color:white;text-decoration:none;border-radius:5px;'>🔧 Ejecutar Migración</a>";

?>

<style>
    body { 
        font-family: Arial, sans-serif; 
        max-width: 900px; 
        margin: 50px auto; 
        padding: 20px;
        background: #f5f5f5;
    }
    h2 { color: #1e3c72; }
    h3 { color: #2a5298; margin-top: 20px; }
    hr { margin: 30px 0; }
    pre {
        background: #f5f5f5;
        padding: 10px;
        border-radius: 5px;
        border-left: 3px solid #1e3c72;
    }
    table {
        background: white;
        margin-top: 10px;
    }
    a {
        display: inline-block;
        margin: 5px 0;
    }
</style>
