<?php
session_start();

// Simular que hay un operador logeado
$_SESSION['operator_id'] = 1;
$_SESSION['operator_role'] = 'admin';

echo "<h2>Test API - Users</h2>";
echo "<h3>GET manage-users.php?action=list</h3>";
echo "<pre>";

// Test users API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/panel-simple/manage-users.php?action=list');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response:\n";
print_r(json_decode($response, true));
echo "</pre>";

echo "<h2>Test API - Operators</h2>";
echo "<h3>GET manage-operators.php?action=list</h3>";
echo "<pre>";

// Test operators API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/panel-simple/manage-operators.php?action=list');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response:\n";
print_r(json_decode($response, true));
echo "</pre>";

// Direct database check
require_once 'config.php';

echo "<h2>Direct Database Query - Users</h2>";
echo "<pre>";
$stmt = $conn->query("SELECT * FROM users LIMIT 5");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
print_r($users);
echo "</pre>";

echo "<h2>Direct Database Query - Operators</h2>";
echo "<pre>";
$stmt = $conn->query("SELECT * FROM operators LIMIT 5");
$operators = $stmt->fetchAll(PDO::FETCH_ASSOC);
print_r($operators);
echo "</pre>";
?>
