<?php
require_once 'config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

$alert_id = $_GET['id'] ?? 0;
$message = '';

// Procesar acciones
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'] ?? '';
    
    try {
        if ($action == 'assign') {
            $stmt = $conn->prepare("UPDATE alerts SET status = 'in_progress', assigned_operator_id = ?, response_time = NOW() WHERE id = ?");
            $stmt->execute([$_SESSION['user_id'], $alert_id]);
            $message = "✅ Alerta asignada correctamente";
        } elseif ($action == 'resolve') {
            $notes = $_POST['notes'] ?? '';
            $stmt = $conn->prepare("UPDATE alerts SET status = 'resolved', notes = ?, resolved_at = NOW() WHERE id = ?");
            $stmt->execute([$notes, $alert_id]);
            $message = "✅ Alerta resuelta correctamente";
        } elseif ($action == 'cancel') {
            $notes = $_POST['notes'] ?? '';
            $stmt = $conn->prepare("UPDATE alerts SET status = 'cancelled', notes = ? WHERE id = ?");
            $stmt->execute([$notes, $alert_id]);
            $message = "⚠️ Alerta cancelada";
        } elseif ($action == 'update_notes') {
            $notes = $_POST['notes'] ?? '';
            $stmt = $conn->prepare("UPDATE alerts SET notes = ? WHERE id = ?");
            $stmt->execute([$notes, $alert_id]);
            $message = "✅ Notas actualizadas";
        }
    } catch(PDOException $e) {
        $message = "❌ Error: " . $e->getMessage();
    }
}

// Obtener datos de la alerta
try {
    $stmt = $conn->prepare("
        SELECT a.*, u.full_name as citizen_name, u.phone as citizen_phone, u.email as citizen_email,
               u.blood_type, u.allergies, u.medical_conditions, u.emergency_contact, u.emergency_phone,
               o.full_name as operator_name
        FROM alerts a 
        LEFT JOIN users u ON a.user_id = u.id 
        LEFT JOIN operators o ON a.assigned_operator_id = o.id 
        WHERE a.id = ?
    ");
    $stmt->execute([$alert_id]);
    $alert = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$alert) {
        header('Location: alertas.php');
        exit;
    }
} catch(PDOException $e) {
    die("Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alerta #<?php echo $alert['id']; ?> - Azuero Safety</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #f5f5f5; }
        
        .header {
            background: #1e3c72;
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .header h1 { font-size: 24px; }
        .back-btn {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 8px 20px;
            border-radius: 5px;
            text-decoration: none;
            transition: background 0.3s;
        }
        .back-btn:hover { background: rgba(255,255,255,0.3); }
        
        .container { max-width: 1200px; margin: 30px auto; padding: 0 20px; }
        
        .message {
            background: #e8f5e9;
            color: #2e7d32;
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #2e7d32;
        }
        
        .grid { display: grid; grid-template-columns: 2fr 1fr; gap: 20px; }
        
        .card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .card h2 {
            color: #1e3c72;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
            font-size: 20px;
        }
        
        .alert-header {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-id {
            font-size: 32px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .alert-type {
            display: inline-block;
            background: rgba(255,255,255,0.2);
            padding: 8px 20px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            margin-right: 10px;
        }
        
        .badge {
            display: inline-block;
            padding: 8px 20px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
        }
        .badge.pending { background: #ffebee; color: #c62828; }
        .badge.in-progress { background: #fff3e0; color: #f57c00; }
        .badge.resolved { background: #e8f5e9; color: #2e7d32; }
        .badge.high { background: #ffebee; color: #c62828; }
        .badge.medium { background: #fff3e0; color: #f57c00; }
        .badge.low { background: #e3f2fd; color: #1976d2; }
        
        .info-group { margin: 15px 0; }
        .info-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
            font-weight: 600;
            margin-bottom: 5px;
        }
        .info-value {
            font-size: 16px;
            color: #333;
            font-weight: 500;
        }
        
        .description-box {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #1e3c72;
            margin: 15px 0;
        }
        
        .map-placeholder {
            background: #e0e0e0;
            height: 200px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #666;
            margin: 15px 0;
        }
        
        .action-buttons {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            text-align: center;
            flex: 1;
        }
        .btn-primary { background: #1e3c72; color: white; }
        .btn-primary:hover { background: #2a5298; }
        .btn-success { background: #2e7d32; color: white; }
        .btn-success:hover { background: #388e3c; }
        .btn-danger { background: #c62828; color: white; }
        .btn-danger:hover { background: #d32f2f; }
        
        textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-family: inherit;
            font-size: 14px;
            resize: vertical;
            min-height: 100px;
        }
        
        .medical-info {
            background: #fff3e0;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #f57c00;
            margin: 10px 0;
        }
        
        .contact-info {
            background: #e3f2fd;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #1976d2;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🚨 Detalle de Alerta #<?php echo $alert['id']; ?></h1>
        <a href="alertas.php" class="back-btn">← Volver a Alertas</a>
    </div>
    
    <div class="container">
        <?php if ($message): ?>
        <div class="message"><?php echo $message; ?></div>
        <?php endif; ?>
        
        <div class="alert-header">
            <div class="alert-id">Alerta #<?php echo $alert['id']; ?></div>
            <span class="alert-type"><?php echo htmlspecialchars($alert['alert_type']); ?></span>
            <span class="badge <?php echo $alert['status']; ?>"><?php echo str_replace('_', ' ', strtoupper($alert['status'])); ?></span>
            <span class="badge <?php echo $alert['priority']; ?>">PRIORIDAD <?php echo strtoupper($alert['priority']); ?></span>
        </div>
        
        <div class="grid">
            <div>
                <div class="card">
                    <h2>📍 Detalles de la Alerta</h2>
                    
                    <div class="info-group">
                        <div class="info-label">Ubicación</div>
                        <div class="info-value">📍 <?php echo htmlspecialchars($alert['location_name'] ?? 'No especificada'); ?></div>
                    </div>
                    
                    <?php if ($alert['latitude'] && $alert['longitude']): ?>
                    <div class="info-group">
                        <div class="info-label">Coordenadas</div>
                        <div class="info-value">🌐 <?php echo $alert['latitude']; ?>, <?php echo $alert['longitude']; ?></div>
                    </div>
                    <div class="map-placeholder">
                        <a href="https://www.google.com/maps?q=<?php echo $alert['latitude']; ?>,<?php echo $alert['longitude']; ?>" target="_blank" style="color: #1e3c72; text-decoration: none;">
                            🗺️ Ver en Google Maps
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    <div class="info-group">
                        <div class="info-label">Fecha y Hora</div>
                        <div class="info-value">⏰ <?php echo date('d/m/Y H:i:s', strtotime($alert['created_at'])); ?></div>
                    </div>
                    
                    <?php if ($alert['description']): ?>
                    <div class="info-group">
                        <div class="info-label">Descripción</div>
                        <div class="description-box">
                            <?php echo nl2br(htmlspecialchars($alert['description'])); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($alert['operator_name']): ?>
                    <div class="info-group">
                        <div class="info-label">Operador Asignado</div>
                        <div class="info-value">👨‍💼 <?php echo htmlspecialchars($alert['operator_name']); ?></div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($alert['response_time']): ?>
                    <div class="info-group">
                        <div class="info-label">Tiempo de Respuesta</div>
                        <div class="info-value">⏱️ <?php echo date('d/m/Y H:i:s', strtotime($alert['response_time'])); ?></div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($alert['resolved_at']): ?>
                    <div class="info-group">
                        <div class="info-label">Resuelta en</div>
                        <div class="info-value">✅ <?php echo date('d/m/Y H:i:s', strtotime($alert['resolved_at'])); ?></div>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="card" style="margin-top: 20px;">
                    <h2>📝 Notas del Operador</h2>
                    <form method="POST">
                        <input type="hidden" name="action" value="update_notes">
                        <textarea name="notes" placeholder="Escribe notas o comentarios sobre esta alerta..."><?php echo htmlspecialchars($alert['notes'] ?? ''); ?></textarea>
                        <button type="submit" class="btn btn-primary" style="margin-top: 10px; width: auto;">Guardar Notas</button>
                    </form>
                </div>
            </div>
            
            <div>
                <div class="card">
                    <h2>👤 Información del Ciudadano</h2>
                    
                    <div class="info-group">
                        <div class="info-label">Nombre Completo</div>
                        <div class="info-value"><?php echo htmlspecialchars($alert['citizen_name'] ?? 'Desconocido'); ?></div>
                    </div>
                    
                    <?php if ($alert['citizen_phone']): ?>
                    <div class="contact-info">
                        <div class="info-label">Teléfono</div>
                        <div class="info-value">📱 <a href="tel:<?php echo $alert['citizen_phone']; ?>"><?php echo htmlspecialchars($alert['citizen_phone']); ?></a></div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($alert['citizen_email']): ?>
                    <div class="info-group">
                        <div class="info-label">Email</div>
                        <div class="info-value">📧 <?php echo htmlspecialchars($alert['citizen_email']); ?></div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($alert['blood_type'] || $alert['allergies'] || $alert['medical_conditions']): ?>
                    <div class="medical-info">
                        <strong>⚕️ Información Médica</strong>
                        <?php if ($alert['blood_type']): ?>
                        <div style="margin-top: 8px;"><strong>Tipo de sangre:</strong> <?php echo htmlspecialchars($alert['blood_type']); ?></div>
                        <?php endif; ?>
                        <?php if ($alert['allergies']): ?>
                        <div style="margin-top: 8px;"><strong>Alergias:</strong> <?php echo htmlspecialchars($alert['allergies']); ?></div>
                        <?php endif; ?>
                        <?php if ($alert['medical_conditions']): ?>
                        <div style="margin-top: 8px;"><strong>Condiciones:</strong> <?php echo htmlspecialchars($alert['medical_conditions']); ?></div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($alert['emergency_contact']): ?>
                    <div class="contact-info">
                        <strong>🆘 Contacto de Emergencia</strong>
                        <div style="margin-top: 8px;"><?php echo htmlspecialchars($alert['emergency_contact']); ?></div>
                        <?php if ($alert['emergency_phone']): ?>
                        <div style="margin-top: 5px;">📱 <a href="tel:<?php echo $alert['emergency_phone']; ?>"><?php echo htmlspecialchars($alert['emergency_phone']); ?></a></div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if ($alert['status'] == 'pending' || $alert['status'] == 'in_progress'): ?>
                <div class="card" style="margin-top: 20px;">
                    <h2>⚡ Acciones Rápidas</h2>
                    
                    <div class="action-buttons">
                        <?php if ($alert['status'] == 'pending'): ?>
                        <form method="POST" style="flex: 1;">
                            <input type="hidden" name="action" value="assign">
                            <button type="submit" class="btn btn-primary">Asignarme</button>
                        </form>
                        <?php endif; ?>
                        
                        <?php if ($alert['status'] == 'in_progress'): ?>
                        <form method="POST" style="flex: 1;">
                            <input type="hidden" name="action" value="resolve">
                            <input type="hidden" name="notes" value="Alerta resuelta satisfactoriamente">
                            <button type="submit" class="btn btn-success" onclick="return confirm('¿Confirmar que la alerta está resuelta?')">✅ Resolver</button>
                        </form>
                        <?php endif; ?>
                        
                        <form method="POST" style="flex: 1;">
                            <input type="hidden" name="action" value="cancel">
                            <input type="hidden" name="notes" value="Alerta cancelada por operador">
                            <button type="submit" class="btn btn-danger" onclick="return confirm('¿Seguro que deseas cancelar esta alerta?')">❌ Cancelar</button>
                        </form>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>
