<?php
// Script para verificar la instalación

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔍 Verificación del Sistema Azuero Safety</h2>";
echo "<hr>";

// 1. Verificar archivos
echo "<h3>✅ Archivos:</h3>";
$files = ['config.php', 'index.php', 'dashboard.php', 'logout.php'];
foreach ($files as $file) {
    if (file_exists($file)) {
        echo "✅ $file existe<br>";
    } else {
        echo "❌ $file NO existe<br>";
    }
}

// 2. Verificar conexión a BD
echo "<h3>🔌 Conexión a Base de Datos:</h3>";
try {
    require_once 'config.php';
    echo "✅ Conexión exitosa<br>";
    echo "📊 Base de datos: " . DB_NAME . "<br>";
    echo "👤 Usuario: " . DB_USER . "<br>";
} catch (Exception $e) {
    echo "❌ Error de conexión: " . $e->getMessage() . "<br>";
    exit;
}

// 3. Verificar tablas
echo "<h3>📋 Tablas:</h3>";
try {
    $tables = ['operators', 'users', 'alerts'];
    foreach ($tables as $table) {
        $stmt = $conn->query("SELECT COUNT(*) as count FROM $table");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "✅ Tabla '$table': " . $result['count'] . " registros<br>";
    }
} catch (PDOException $e) {
    echo "❌ Error verificando tablas: " . $e->getMessage() . "<br>";
}

// 4. Verificar usuario admin
echo "<h3>👤 Usuario Admin:</h3>";
try {
    $stmt = $conn->query("SELECT * FROM operators WHERE username = 'admin'");
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($admin) {
        echo "✅ Usuario admin existe<br>";
        echo "📧 Email: " . $admin['email'] . "<br>";
        echo "👔 Nombre: " . $admin['full_name'] . "<br>";
        echo "🔑 Rol: " . $admin['role'] . "<br>";
        echo "📊 Estado: " . $admin['status'] . "<br>";
        echo "🔒 Hash de contraseña: " . substr($admin['password'], 0, 20) . "...<br>";
        
        // Probar contraseña
        if (password_verify('password123', $admin['password'])) {
            echo "✅ La contraseña 'password123' es válida<br>";
        } else {
            echo "❌ La contraseña 'password123' NO es válida<br>";
            echo "<br><strong>⚠️ SOLUCIÓN:</strong> Ejecuta este query en phpMyAdmin:<br>";
            $newHash = password_hash('password123', PASSWORD_DEFAULT);
            echo "<code>UPDATE operators SET password = '$newHash' WHERE username = 'admin';</code><br>";
        }
    } else {
        echo "❌ Usuario admin NO existe<br>";
        echo "<br><strong>⚠️ SOLUCIÓN:</strong> Ejecuta este query en phpMyAdmin:<br>";
        $hash = password_hash('password123', PASSWORD_DEFAULT);
        echo "<code>INSERT INTO operators (username, password, full_name, email, role, status) VALUES ('admin', '$hash', 'Administrador del Sistema', 'admin@azuerosafety.com', 'admin', 'active');</code><br>";
    }
} catch (PDOException $e) {
    echo "❌ Error verificando admin: " . $e->getMessage() . "<br>";
}

// 5. Verificar sesiones
echo "<h3>🔐 Sesiones PHP:</h3>";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "✅ Sesiones activas<br>";
} else {
    echo "⚠️ Sesiones no activas<br>";
}

echo "<hr>";
echo "<h3>🎯 Próximo paso:</h3>";
echo "<p>Si todo está en ✅, ve a: <a href='index.php'>index.php</a></p>";
echo "<p><strong>Usuario:</strong> admin<br><strong>Contraseña:</strong> password123</p>";
?>

<style>
    body { 
        font-family: Arial, sans-serif; 
        max-width: 800px; 
        margin: 50px auto; 
        padding: 20px;
        background: #f5f5f5;
    }
    h2 { color: #1e3c72; }
    h3 { color: #2a5298; margin-top: 20px; }
    code { 
        background: #fff3cd; 
        padding: 10px; 
        display: block; 
        margin: 10px 0;
        border-left: 3px solid #f57c00;
        font-size: 12px;
    }
    hr { margin: 30px 0; }
</style>
