<?php
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'citizen') {
    header('Location: index.php');
    exit;
}

$alertId = $_GET['id'] ?? 0;

require_once 'config.php';

try {
    $pdo = new PDO(
        "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    $stmt = $pdo->prepare("
        SELECT a.*, u.full_name, u.phone, u.email
        FROM alerts a
        LEFT JOIN users u ON a.user_id = u.id
        WHERE a.id = ? AND a.user_id = ?
    ");
    $stmt->execute([$alertId, $_SESSION['user_id']]);
    $alert = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$alert) {
        header('Location: my-alerts.php');
        exit;
    }
} catch(PDOException $e) {
    die("Error de conexión");
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#667eea">
    <title>Detalle de Alerta - Azuero Safety</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f7fa;
            padding-bottom: 80px;
        }

        .header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 15px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .btn-back {
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 38px;
            height: 38px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            cursor: pointer;
        }

        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }

        .header-title p {
            font-size: 12px;
            opacity: 0.9;
            margin-top: 2px;
        }

        .container {
            padding: 15px;
        }

        .alert-badge {
            background: white;
            border-radius: 16px;
            padding: 20px;
            text-align: center;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        .alert-icon-large {
            width: 80px;
            height: 80px;
            margin: 0 auto 15px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 35px;
        }

        .alert-icon-large.panic {
            background: #fee;
            color: #d63031;
        }

        .alert-icon-large.medical {
            background: #fff3cd;
            color: #ffc107;
        }

        .alert-type-title {
            font-size: 22px;
            font-weight: 700;
            color: #333;
            margin-bottom: 8px;
        }

        .alert-id {
            font-size: 13px;
            color: #999;
            margin-bottom: 12px;
        }

        .status-badge {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
        }

        .status-badge.pending {
            background: #fff3cd;
            color: #856404;
        }

        .status-badge.in_progress {
            background: #d1ecf1;
            color: #055160;
        }

        .status-badge.resolved {
            background: #d1e7dd;
            color: #0f5132;
        }

        .info-card {
            background: white;
            border-radius: 14px;
            padding: 18px;
            margin-bottom: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        .info-card h3 {
            font-size: 15px;
            font-weight: 700;
            color: #333;
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-size: 13px;
            color: #666;
        }

        .info-value {
            font-size: 13px;
            font-weight: 600;
            color: #333;
            text-align: right;
        }

        .map-container {
            width: 100%;
            height: 200px;
            background: #e9ecef;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #666;
            margin-top: 12px;
        }

        .action-buttons {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            padding: 12px 15px;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
        }

        .btn-action {
            padding: 14px;
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-cancel {
            background: #f8d7da;
            color: #842029;
        }

        .btn-call {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }

        .timeline {
            position: relative;
            padding-left: 30px;
        }

        .timeline::before {
            content: '';
            position: absolute;
            left: 10px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #e0e0e0;
        }

        .timeline-item {
            position: relative;
            padding-bottom: 20px;
        }

        .timeline-item::before {
            content: '';
            position: absolute;
            left: -23px;
            top: 5px;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #667eea;
            border: 3px solid white;
            box-shadow: 0 0 0 2px #667eea;
        }

        .timeline-time {
            font-size: 12px;
            color: #999;
            margin-bottom: 4px;
        }

        .timeline-text {
            font-size: 13px;
            color: #333;
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <button class="btn-back" onclick="location.href='my-alerts.php'">
                <i class="fas fa-arrow-left"></i>
            </button>
            <div class="header-title">
                <h1>Detalle de Alerta</h1>
                <p>ID: #<?php echo str_pad($alert['id'], 5, '0', STR_PAD_LEFT); ?></p>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="alert-badge">
            <div class="alert-icon-large <?php echo $alert['alert_type']; ?>">
                <i class="fas fa-<?php 
                    $icons = ['panic' => 'exclamation-triangle', 'medical' => 'ambulance', 'security' => 'shield-alt', 'fire' => 'fire'];
                    echo $icons[$alert['alert_type']] ?? 'bell';
                ?>"></i>
            </div>
            <div class="alert-type-title">
                <?php 
                    $names = ['panic' => 'Alerta de Pánico', 'medical' => 'Emergencia Médica', 'security' => 'Seguridad', 'fire' => 'Incendio'];
                    echo $names[$alert['alert_type']] ?? $alert['alert_type'];
                ?>
            </div>
            <div class="alert-id">Alerta #<?php echo str_pad($alert['id'], 5, '0', STR_PAD_LEFT); ?></div>
            <span class="status-badge <?php echo $alert['status']; ?>">
                <?php 
                    $statuses = ['pending' => 'Pendiente', 'in_progress' => 'En Proceso', 'resolved' => 'Resuelta'];
                    echo $statuses[$alert['status']] ?? $alert['status'];
                ?>
            </span>
        </div>

        <div class="info-card">
            <h3><i class="fas fa-info-circle"></i> Información General</h3>
            <div class="info-row">
                <span class="info-label">Fecha de Creación</span>
                <span class="info-value"><?php echo date('d/m/Y H:i', strtotime($alert['created_at'])); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Última Actualización</span>
                <span class="info-value"><?php echo date('d/m/Y H:i', strtotime($alert['updated_at'])); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Prioridad</span>
                <span class="info-value" style="color: <?php echo $alert['priority'] === 'high' ? '#d63031' : '#667eea'; ?>">
                    <?php echo strtoupper($alert['priority'] ?? 'MEDIA'); ?>
                </span>
            </div>
        </div>

        <?php if ($alert['latitude'] && $alert['longitude']): ?>
        <div class="info-card">
            <h3><i class="fas fa-map-marker-alt"></i> Ubicación</h3>
            <div class="info-row">
                <span class="info-label">Coordenadas</span>
                <span class="info-value"><?php echo number_format($alert['latitude'], 6); ?>, <?php echo number_format($alert['longitude'], 6); ?></span>
            </div>
            <?php if ($alert['location_name']): ?>
            <div class="info-row">
                <span class="info-label">Dirección</span>
                <span class="info-value"><?php echo htmlspecialchars($alert['location_name']); ?></span>
            </div>
            <?php endif; ?>
            <div class="map-container">
                <div>
                    <i class="fas fa-map fa-2x" style="margin-bottom: 10px;"></i>
                    <p>Mapa de ubicación</p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($alert['description']): ?>
        <div class="info-card">
            <h3><i class="fas fa-file-alt"></i> Descripción</h3>
            <p style="font-size: 13px; color: #666; line-height: 1.6;">
                <?php echo nl2br(htmlspecialchars($alert['description'])); ?>
            </p>
        </div>
        <?php endif; ?>

        <div class="info-card">
            <h3><i class="fas fa-history"></i> Línea de Tiempo</h3>
            <div class="timeline">
                <div class="timeline-item">
                    <div class="timeline-time"><?php echo date('d/m/Y H:i', strtotime($alert['created_at'])); ?></div>
                    <div class="timeline-text">Alerta creada</div>
                </div>
                <?php if ($alert['response_time']): ?>
                <div class="timeline-item">
                    <div class="timeline-time"><?php echo date('d/m/Y H:i', strtotime($alert['response_time'])); ?></div>
                    <div class="timeline-text">Operador asignado</div>
                </div>
                <?php endif; ?>
                <?php if ($alert['resolved_at']): ?>
                <div class="timeline-item">
                    <div class="timeline-time"><?php echo date('d/m/Y H:i', strtotime($alert['resolved_at'])); ?></div>
                    <div class="timeline-text">Alerta resuelta</div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="action-buttons">
        <?php if ($alert['status'] === 'pending'): ?>
        <button class="btn-action btn-cancel" onclick="cancelAlert()">
            <i class="fas fa-times"></i> Cancelar
        </button>
        <?php endif; ?>
        <button class="btn-action btn-call" onclick="callEmergency()">
            <i class="fas fa-phone"></i> Llamar 911
        </button>
    </div>

    <script>
        function cancelAlert() {
            if (confirm('¿Estás seguro de cancelar esta alerta?')) {
                fetch('api-alerts.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: 'action=cancel&id=<?php echo $alert['id']; ?>'
                })
                .then(r => r.json())
                .then(data => {
                    if (data.success) {
                        alert('Alerta cancelada');
                        location.reload();
                    } else {
                        alert('Error: ' + data.error);
                    }
                });
            }
        }

        function callEmergency() {
            window.location.href = 'tel:911';
        }
    </script>
</body>
</html>
