<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'No autorizado']);
    exit;
}

require_once 'config.php';

try {
    $pdo = new PDO(
        "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Error de conexión']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? $_POST['action'] ?? '';
$userId = $_SESSION['user_id'];
$userType = $_SESSION['user_type'] ?? 'citizen';

switch($action) {
    case 'subscribe':
        // Guardar suscripción de push notification
        $subscription = $input['subscription'] ?? null;
        
        if (!$subscription) {
            echo json_encode(['success' => false, 'error' => 'Suscripción inválida']);
            exit;
        }

        $endpoint = $subscription['endpoint'] ?? '';
        $keys = json_encode($subscription['keys'] ?? []);

        // Verificar si ya existe
        $stmt = $pdo->prepare("
            SELECT id FROM push_subscriptions 
            WHERE user_id = ? AND user_type = ? AND endpoint = ?
        ");
        $stmt->execute([$userId, $userType, $endpoint]);
        
        if ($stmt->fetch()) {
            echo json_encode(['success' => true, 'message' => 'Suscripción ya existe']);
            exit;
        }

        // Insertar nueva suscripción
        $stmt = $pdo->prepare("
            INSERT INTO push_subscriptions (user_id, user_type, endpoint, keys_json, created_at)
            VALUES (?, ?, ?, ?, NOW())
        ");
        
        if ($stmt->execute([$userId, $userType, $endpoint, $keys])) {
            echo json_encode(['success' => true, 'message' => 'Suscripción guardada']);
        } else {
            echo json_encode(['success' => false, 'error' => 'Error al guardar suscripción']);
        }
        break;

    case 'unsubscribe':
        // Eliminar suscripción
        $endpoint = $input['endpoint'] ?? '';

        $stmt = $pdo->prepare("
            DELETE FROM push_subscriptions 
            WHERE user_id = ? AND endpoint = ?
        ");
        
        if ($stmt->execute([$userId, $endpoint])) {
            echo json_encode(['success' => true, 'message' => 'Suscripción eliminada']);
        } else {
            echo json_encode(['success' => false, 'error' => 'Error al eliminar']);
        }
        break;

    case 'send':
        // Enviar notificación push (solo operadores)
        if ($userType !== 'operator') {
            echo json_encode(['success' => false, 'error' => 'No autorizado']);
            exit;
        }

        $title = $input['title'] ?? 'Azuero Safety';
        $body = $input['body'] ?? '';
        $targetUserId = $input['target_user_id'] ?? null;
        $targetType = $input['target_type'] ?? 'citizen';

        // Obtener suscripciones del usuario objetivo
        $query = "SELECT endpoint, keys_json FROM push_subscriptions WHERE user_type = ?";
        $params = [$targetType];

        if ($targetUserId) {
            $query .= " AND user_id = ?";
            $params[] = $targetUserId;
        }

        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        $subscriptions = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $sent = 0;
        $failed = 0;

        foreach ($subscriptions as $subscription) {
            try {
                // Aquí iría la lógica de envío usando una librería como web-push
                // Por ahora solo retornamos éxito
                $sent++;
            } catch (Exception $e) {
                $failed++;
            }
        }

        echo json_encode([
            'success' => true,
            'sent' => $sent,
            'failed' => $failed,
            'message' => "Notificaciones enviadas: $sent, Fallidas: $failed"
        ]);
        break;

    case 'test':
        // Enviar notificación de prueba
        echo json_encode([
            'success' => true,
            'message' => 'Notificación de prueba (requiere implementación completa de push server)'
        ]);
        break;

    default:
        echo json_encode(['success' => false, 'error' => 'Acción no válida']);
}
?>
