<?php
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'citizen') {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#667eea">
    <title>Contactos de Emergencia - Azuero Safety</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f7fa;
            padding-bottom: 150px;
        }

        .header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 15px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .btn-back {
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 38px;
            height: 38px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            cursor: pointer;
        }

        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }

        .header-title p {
            font-size: 12px;
            opacity: 0.9;
        }

        .container {
            padding: 15px;
        }

        .emergency-numbers {
            background: linear-gradient(135deg, #dc3545, #c82333);
            color: white;
            border-radius: 14px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
        }

        .emergency-numbers h2 {
            font-size: 16px;
            font-weight: 700;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .emergency-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }

        .emergency-btn {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 15px;
            border-radius: 10px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }

        .emergency-btn:active {
            transform: scale(0.95);
            background: rgba(255,255,255,0.3);
        }

        .emergency-btn i {
            font-size: 24px;
            margin-bottom: 8px;
        }

        .emergency-btn .label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            margin-bottom: 4px;
        }

        .emergency-btn .number {
            display: block;
            font-size: 18px;
            font-weight: 700;
        }

        .contacts-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .contacts-header h2 {
            font-size: 18px;
            font-weight: 700;
            color: #333;
        }

        .btn-add {
            background: #667eea;
            color: white;
            border: none;
            padding: 10px 16px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .contact-card {
            background: white;
            border-radius: 14px;
            padding: 16px;
            margin-bottom: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        .contact-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }

        .contact-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: 700;
        }

        .contact-info h3 {
            font-size: 16px;
            font-weight: 700;
            color: #333;
            margin-bottom: 3px;
        }

        .contact-info p {
            font-size: 13px;
            color: #999;
        }

        .contact-actions {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr;
            gap: 8px;
        }

        .btn-action {
            padding: 10px;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            background: white;
            cursor: pointer;
            font-size: 13px;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
            transition: all 0.3s;
        }

        .btn-action.call {
            background: #28a745;
            color: white;
            border-color: #28a745;
        }

        .btn-action.edit {
            color: #667eea;
        }

        .btn-action.delete {
            color: #dc3545;
        }

        .btn-action:active {
            transform: scale(0.95);
        }

        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #999;
        }

        .empty-state i {
            font-size: 50px;
            margin-bottom: 15px;
            opacity: 0.5;
        }

        .empty-state p {
            font-size: 14px;
            line-height: 1.6;
        }

        /* Modal */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 1000;
            padding: 20px;
            align-items: center;
            justify-content: center;
        }

        .modal.active {
            display: flex;
        }

        .modal-content {
            background: white;
            border-radius: 16px;
            padding: 20px;
            width: 100%;
            max-width: 400px;
            max-height: 90vh;
            overflow-y: auto;
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .modal-header h3 {
            font-size: 18px;
            font-weight: 700;
            color: #333;
        }

        .btn-close {
            background: none;
            border: none;
            font-size: 24px;
            color: #999;
            cursor: pointer;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: #555;
            margin-bottom: 6px;
        }

        .form-input {
            width: 100%;
            padding: 12px;
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            font-size: 14px;
            font-family: inherit;
        }

        .form-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn-save {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            padding: 8px 0;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
        }

        .nav-item {
            text-align: center;
            padding: 8px;
            color: #999;
            text-decoration: none;
        }

        .nav-item i {
            font-size: 20px;
            margin-bottom: 4px;
        }

        .nav-item span {
            display: block;
            font-size: 11px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <button class="btn-back" onclick="location.href='dashboard.php'">
                <i class="fas fa-arrow-left"></i>
            </button>
            <div class="header-title">
                <h1>Contactos de Emergencia</h1>
                <p>Gestiona tus contactos</p>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="emergency-numbers">
            <h2><i class="fas fa-phone-volume"></i> Números de Emergencia</h2>
            <div class="emergency-grid">
                <a href="tel:911" class="emergency-btn">
                    <i class="fas fa-shield-alt"></i>
                    <span class="label">Policía</span>
                    <span class="number">911</span>
                </a>
                <a href="tel:103" class="emergency-btn">
                    <i class="fas fa-ambulance"></i>
                    <span class="label">Ambulancia</span>
                    <span class="number">103</span>
                </a>
                <a href="tel:103" class="emergency-btn">
                    <i class="fas fa-fire-extinguisher"></i>
                    <span class="label">Bomberos</span>
                    <span class="number">103</span>
                </a>
                <a href="tel:104" class="emergency-btn">
                    <i class="fas fa-heartbeat"></i>
                    <span class="label">Cruz Roja</span>
                    <span class="number">104</span>
                </a>
            </div>
        </div>

        <div class="contacts-header">
            <h2>Mis Contactos</h2>
            <button class="btn-add" onclick="openModal()">
                <i class="fas fa-plus"></i> Agregar
            </button>
        </div>

        <div id="contacts-list">
            <!-- Contacts will be loaded here -->
        </div>
    </div>

    <!-- Modal Add/Edit Contact -->
    <div class="modal" id="contact-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="modal-title">Agregar Contacto</h3>
                <button class="btn-close" onclick="closeModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form id="contact-form">
                <input type="hidden" id="contact-id">
                <div class="form-group">
                    <label class="form-label">Nombre Completo</label>
                    <input type="text" id="contact-name" class="form-input" placeholder="Ej: María González" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Teléfono</label>
                    <input type="tel" id="contact-phone" class="form-input" placeholder="+507 6000-0000" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Relación</label>
                    <input type="text" id="contact-relation" class="form-input" placeholder="Ej: Hermana, Amigo, Vecino">
                </div>
                <button type="submit" class="btn-save">
                    <i class="fas fa-save"></i> Guardar Contacto
                </button>
            </form>
        </div>
    </div>

    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Inicio</span>
        </a>
        <a href="my-alerts.php" class="nav-item">
            <i class="fas fa-bell"></i>
            <span>Alertas</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user"></i>
            <span>Perfil</span>
        </a>
        <a href="settings.php" class="nav-item">
            <i class="fas fa-cog"></i>
            <span>Ajustes</span>
        </a>
    </div>

    <script>
        let contacts = JSON.parse(localStorage.getItem('emergency_contacts') || '[]');

        function loadContacts() {
            const container = document.getElementById('contacts-list');
            
            if (contacts.length === 0) {
                container.innerHTML = `
                    <div class="empty-state">
                        <i class="fas fa-user-friends"></i>
                        <p>No tienes contactos de emergencia.<br>Agrega personas de confianza.</p>
                    </div>
                `;
                return;
            }

            container.innerHTML = contacts.map((contact, index) => `
                <div class="contact-card">
                    <div class="contact-header">
                        <div class="contact-avatar">
                            ${contact.name.charAt(0).toUpperCase()}
                        </div>
                        <div class="contact-info">
                            <h3>${contact.name}</h3>
                            <p>${contact.relation || 'Sin relación especificada'}</p>
                        </div>
                    </div>
                    <div class="contact-actions">
                        <button class="btn-action call" onclick="callContact('${contact.phone}')">
                            <i class="fas fa-phone"></i> Llamar
                        </button>
                        <button class="btn-action edit" onclick="editContact(${index})">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="btn-action delete" onclick="deleteContact(${index})">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            `).join('');
        }

        function openModal(index = null) {
            const modal = document.getElementById('contact-modal');
            const title = document.getElementById('modal-title');
            
            if (index !== null) {
                const contact = contacts[index];
                document.getElementById('contact-id').value = index;
                document.getElementById('contact-name').value = contact.name;
                document.getElementById('contact-phone').value = contact.phone;
                document.getElementById('contact-relation').value = contact.relation || '';
                title.textContent = 'Editar Contacto';
            } else {
                document.getElementById('contact-form').reset();
                document.getElementById('contact-id').value = '';
                title.textContent = 'Agregar Contacto';
            }
            
            modal.classList.add('active');
        }

        function closeModal() {
            document.getElementById('contact-modal').classList.remove('active');
        }

        document.getElementById('contact-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const id = document.getElementById('contact-id').value;
            const contact = {
                name: document.getElementById('contact-name').value,
                phone: document.getElementById('contact-phone').value,
                relation: document.getElementById('contact-relation').value
            };

            if (id !== '') {
                contacts[parseInt(id)] = contact;
            } else {
                contacts.push(contact);
            }

            localStorage.setItem('emergency_contacts', JSON.stringify(contacts));
            loadContacts();
            closeModal();
            showToast('Contacto guardado');
        });

        function editContact(index) {
            openModal(index);
        }

        function deleteContact(index) {
            if (confirm('¿Eliminar este contacto?')) {
                contacts.splice(index, 1);
                localStorage.setItem('emergency_contacts', JSON.stringify(contacts));
                loadContacts();
                showToast('Contacto eliminado');
            }
        }

        function callContact(phone) {
            window.location.href = 'tel:' + phone;
        }

        function showToast(message) {
            const toast = document.createElement('div');
            toast.style.cssText = 'position:fixed;top:20px;left:50%;transform:translateX(-50%);background:#333;color:white;padding:12px 24px;border-radius:8px;z-index:10000;font-size:14px;';
            toast.textContent = message;
            document.body.appendChild(toast);
            setTimeout(() => toast.remove(), 2000);
        }

        // Load contacts on page load
        loadContacts();
    </script>
</body>
</html>
