<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#667eea">
    <title>Azuero Safety - Sign In</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
            overflow-x: hidden;
            margin: 0 auto;
        }

        .login-container {
            width: 100%;
            max-width: 420px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 50px rgba(0,0,0,0.3);
            overflow: hidden;
            animation: slideUp 0.5s ease;
            margin: 0 auto;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            padding: 30px 25px 25px;
            text-align: center;
            color: white;
        }

        .logo {
            width: 70px;
            height: 70px;
            margin: 0 auto 15px;
            background: rgba(255,255,255,0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 35px;
            backdrop-filter: blur(10px);
        }

        .login-header h1 {
            font-size: 24px;
            margin-bottom: 5px;
            font-weight: 700;
        }

        .login-header p {
            font-size: 13px;
            opacity: 0.9;
        }

        .login-body {
            padding: 25px 25px 30px;
        }

        .form-group {
            margin-bottom: 18px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 13px;
        }

        .input-wrapper {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #999;
            font-size: 16px;
        }

        input {
            width: 100%;
            padding: 14px 14px 14px 45px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 15px;
            transition: all 0.3s;
            background: #f8f9fa;
        }

        input:focus {
            outline: none;
            border-color: #667eea;
            background: white;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 20px;
        }

        .remember-me input[type="checkbox"] {
            width: 18px;
            height: 18px;
            padding: 0;
            cursor: pointer;
        }

        .remember-me label {
            font-size: 13px;
            color: #666;
            cursor: pointer;
            margin: 0;
        }

        .btn-login {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 15px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-login:active {
            transform: scale(0.98);
        }

        .btn-login:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .divider {
            text-align: center;
            margin: 20px 0;
            color: #999;
            font-size: 13px;
            position: relative;
        }

        .divider::before,
        .divider::after {
            content: '';
            position: absolute;
            top: 50%;
            width: 42%;
            height: 1px;
            background: #e0e0e0;
        }

        .divider::before { left: 0; }
        .divider::after { right: 0; }

        .btn-register {
            width: 100%;
            padding: 14px;
            background: white;
            color: #667eea;
            border: 2px solid #667eea;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-register:active {
            background: #f8f9fa;
        }

        .alert {
            padding: 12px;
            border-radius: 10px;
            margin-bottom: 15px;
            font-size: 13px;
            display: none;
        }

        .alert-error {
            background: #fee;
            color: #c33;
            border: 1px solid #fcc;
        }

        .alert-success {
            background: #efe;
            color: #3c3;
            border: 1px solid #cfc;
        }

        .loading {
            display: none;
            text-align: center;
            margin: 10px 0;
        }

        .loading i {
            font-size: 22px;
            color: #667eea;
            animation: spin 1s linear infinite;
        }

        .loading p {
            font-size: 13px;
            color: #666;
            margin-top: 8px;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        .footer {
            text-align: center;
            padding: 15px;
            font-size: 12px;
            color: rgba(255,255,255,0.8);
        }

        .footer p {
            margin: 3px 0;
        }

        /* PWA Install Button */
        .install-prompt {
            position: fixed;
            bottom: 15px;
            left: 15px;
            right: 15px;
            background: white;
            padding: 12px 15px;
            border-radius: 14px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.3);
            display: none;
            align-items: center;
            gap: 12px;
            animation: slideUp 0.3s ease;
        }

        .install-prompt.show {
            display: flex;
        }

        .install-icon {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            flex-shrink: 0;
        }

        .install-content {
            flex: 1;
        }

        .install-content h4 {
            font-size: 14px;
            margin-bottom: 3px;
        }

        .install-content p {
            font-size: 11px;
            color: #666;
        }

        .btn-install {
            padding: 8px 16px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 13px;
        }

        .btn-close-install {
            background: none;
            border: none;
            font-size: 18px;
            color: #999;
            cursor: pointer;
            padding: 0 8px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <div class="logo">
                <i class="fas fa-shield-alt"></i>
            </div>
            <h1>Azuero Safety</h1>
            <p>Mobile Emergency System</p>
        </div>

        <div class="login-body">
            <div id="alert" class="alert"></div>
            <div class="loading" id="loading">
                <i class="fas fa-spinner fa-spin"></i>
                <p>Signing in...</p>
            </div>

            <form id="loginForm">
                <div class="form-group">
                    <label>Email or Username</label>
                    <div class="input-wrapper">
                        <i class="fas fa-envelope input-icon"></i>
                        <input type="text" id="email" name="email" placeholder="Enter your email" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Password</label>
                    <div class="input-wrapper">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" id="password" name="password" placeholder="Enter your password" required>
                    </div>
                </div>

                <div class="remember-me">
                    <input type="checkbox" id="remember" name="remember" checked>
                    <label for="remember">Keep me signed in</label>
                </div>

                <button type="submit" class="btn-login">
                    <i class="fas fa-sign-in-alt"></i> Sign In
                </button>

                <div class="divider">or</div>

                <button type="button" class="btn-register" onclick="window.location.href='register.php'">
                    <i class="fas fa-user-plus"></i> Create New Account
                </button>
            </form>
        </div>
    </div>

    <div class="footer">
        <p>© 2025 Azuero Safety Services S.A.</p>
        <p>We are your safety</p>
    </div>

    <!-- PWA Install Prompt -->
    <div class="install-prompt" id="installPrompt">
        <div class="install-icon">
            <i class="fas fa-mobile-alt"></i>
        </div>
        <div class="install-content">
            <h4>Install App</h4>
            <p>Quick access from your home screen</p>
        </div>
        <button class="btn-install" id="btnInstall">Install</button>
        <button class="btn-close-install" id="btnCloseInstall">×</button>
    </div>

    <script>
        // Form submission
        document.getElementById('loginForm').addEventListener('submit', async function(e) {
            e.preventDefault();

            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;
            const remember = document.getElementById('remember').checked;

            // Show loading
            document.getElementById('loading').style.display = 'block';
            document.querySelector('.btn-login').disabled = true;

            try {
                const formData = new FormData();
                formData.append('email', email);
                formData.append('password', password);
                formData.append('remember', remember ? '1' : '0');

                const response = await fetch('login.php', {
                    method: 'POST',
                    body: formData
                });

                const result = await response.json();

                if (result.success) {
                    showAlert('Welcome! Redirecting...', 'success');
                    
                    setTimeout(() => {
                        window.location.href = 'dashboard.php';
                    }, 1000);
                } else {
                    showAlert(result.error || 'Sign in error', 'error');
                }
            } catch (error) {
                showAlert('Connection error. Try again.', 'error');
            } finally {
                document.getElementById('loading').style.display = 'none';
                document.querySelector('.btn-login').disabled = false;
            }
        });

        function showAlert(message, type) {
            const alert = document.getElementById('alert');
            alert.textContent = message;
            alert.className = 'alert alert-' + type;
            alert.style.display = 'block';

            setTimeout(() => {
                alert.style.display = 'none';
            }, 4000);
        }

        // PWA Install
        let deferredPrompt;

        window.addEventListener('beforeinstallprompt', (e) => {
            e.preventDefault();
            deferredPrompt = e;
            
            // Show install prompt after 3 seconds
            setTimeout(() => {
                document.getElementById('installPrompt').classList.add('show');
            }, 3000);
        });

        document.getElementById('btnInstall').addEventListener('click', async () => {
            if (deferredPrompt) {
                deferredPrompt.prompt();
                const { outcome } = await deferredPrompt.userChoice;
                
                if (outcome === 'accepted') {
                    console.log('PWA installed');
                }
                
                deferredPrompt = null;
                document.getElementById('installPrompt').classList.remove('show');
            }
        });

        document.getElementById('btnCloseInstall').addEventListener('click', () => {
            document.getElementById('installPrompt').classList.remove('show');
        });

        // Check for remembered session
        window.addEventListener('load', () => {
            const rememberedEmail = localStorage.getItem('remembered_email');
            if (rememberedEmail) {
                document.getElementById('email').value = rememberedEmail;
                document.getElementById('remember').checked = true;
            }
        });

        // Prevent zoom on input focus (iOS)
        document.querySelectorAll('input').forEach(input => {
            input.addEventListener('focus', function() {
                this.style.fontSize = '16px';
            });
        });
    </script>
</body>
</html>
