<?php
session_start();
header('Content-Type: application/json');

// Database connection
require_once 'config.php';

try {
    $pdo = new PDO(
        "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Error de conexión']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $pass = $_POST['password'] ?? '';
    $remember = $_POST['remember'] ?? '0';

    if (empty($email) || empty($pass)) {
        echo json_encode(['success' => false, 'error' => 'Email y contraseña requeridos']);
        exit;
    }

    try {
        // Login SOLO para ciudadanos (versión móvil)
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? OR username = ?");
        $stmt->execute([$email, $email]);
        $user = $stmt->fetch();

        if ($user && password_verify($pass, $user['password'])) {
            if ($user['status'] !== 'active') {
                echo json_encode(['success' => false, 'error' => 'Cuenta inactiva']);
                exit;
            }

            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_type'] = 'citizen';
            $_SESSION['username'] = $user['username'] ?? $user['email'];
            $_SESSION['full_name'] = $user['full_name'];
            $_SESSION['mobile'] = true;

            if ($remember === '1') {
                setcookie('mobile_user', $user['id'], time() + (30 * 24 * 60 * 60), '/');
                setcookie('mobile_role', 'citizen', time() + (30 * 24 * 60 * 60), '/');
            }

            echo json_encode([
                'success' => true,
                'role' => 'citizen',
                'username' => $user['username'] ?? $user['email']
            ]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Credenciales incorrectas']);
        }
    } catch(PDOException $e) {
        echo json_encode(['success' => false, 'error' => 'Error en el servidor']);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Método no permitido']);
}
?>
