<?php
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'citizen') {
    header('Location: index.php');
    exit;
}

require_once 'config.php';

$message = '';
$error = '';

try {
    $pdo = new PDO(
        "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $full_name = trim($_POST['full_name'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $cedula = trim($_POST['cedula'] ?? '');
        $blood_type = trim($_POST['blood_type'] ?? '');
        $allergies = trim($_POST['allergies'] ?? '');
        $medical_conditions = trim($_POST['medical_conditions'] ?? '');
        $emergency_contact_name = trim($_POST['emergency_contact_name'] ?? '');
        $emergency_contact_phone = trim($_POST['emergency_contact_phone'] ?? '');

        if (empty($full_name) || empty($email)) {
            $error = 'Nombre y email son obligatorios';
        } else {
            $stmt = $pdo->prepare("
                UPDATE users SET
                    full_name = ?,
                    phone = ?,
                    email = ?,
                    cedula = ?,
                    blood_type = ?,
                    allergies = ?,
                    medical_conditions = ?,
                    emergency_contact_name = ?,
                    emergency_contact_phone = ?
                WHERE id = ?
            ");
            
            if ($stmt->execute([
                $full_name, $phone, $email, $cedula, $blood_type,
                $allergies, $medical_conditions, $emergency_contact_name,
                $emergency_contact_phone, $_SESSION['user_id']
            ])) {
                $_SESSION['full_name'] = $full_name;
                $message = 'Perfil actualizado correctamente';
            } else {
                $error = 'Error al actualizar perfil';
            }
        }
    }

    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

} catch(PDOException $e) {
    $error = 'Error de conexión a la base de datos';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#667eea">
    <title>Mi Perfil - Azuero Safety</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f7fa;
            padding-bottom: 80px;
        }

        .header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 15px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .btn-back {
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 38px;
            height: 38px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            cursor: pointer;
        }

        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }

        .container {
            padding: 15px;
        }

        .profile-avatar {
            text-align: center;
            padding: 25px 0;
        }

        .avatar-circle {
            width: 100px;
            height: 100px;
            margin: 0 auto 12px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 40px;
            font-weight: 700;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }

        .section-card {
            background: white;
            border-radius: 14px;
            padding: 18px;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        .section-title {
            font-size: 15px;
            font-weight: 700;
            color: #333;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: #555;
            margin-bottom: 6px;
        }

        .form-input {
            width: 100%;
            padding: 12px 14px;
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            font-size: 14px;
            font-family: inherit;
            transition: all 0.3s;
        }

        .form-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        textarea.form-input {
            min-height: 80px;
            resize: vertical;
        }

        select.form-input {
            appearance: none;
            background: white url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23333' d='M6 9L1 4h10z'/%3E%3C/svg%3E") no-repeat right 12px center;
            padding-right: 35px;
        }

        .btn-save {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-save:active {
            transform: scale(0.98);
        }

        .alert {
            padding: 12px;
            border-radius: 10px;
            margin-bottom: 15px;
            font-size: 13px;
        }

        .alert-success {
            background: #d1e7dd;
            color: #0f5132;
        }

        .alert-error {
            background: #f8d7da;
            color: #842029;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            padding: 8px 0;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
        }

        .nav-item {
            text-align: center;
            padding: 8px;
            color: #999;
            text-decoration: none;
            transition: all 0.3s;
        }

        .nav-item i {
            font-size: 20px;
            margin-bottom: 4px;
        }

        .nav-item span {
            display: block;
            font-size: 11px;
        }

        .nav-item.active {
            color: #667eea;
        }

        .password-section {
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid #f0f0f0;
        }

        .btn-change-password {
            width: 100%;
            padding: 12px;
            background: #f8f9fa;
            color: #667eea;
            border: 1px solid #667eea;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <button class="btn-back" onclick="location.href='dashboard.php'">
                <i class="fas fa-arrow-left"></i>
            </button>
            <div class="header-title">
                <h1>Mi Perfil</h1>
            </div>
        </div>
    </div>

    <div class="container">
        <?php if ($message): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <div class="profile-avatar">
            <div class="avatar-circle">
                <?php echo strtoupper(substr($user['full_name'] ?? 'U', 0, 1)); ?>
            </div>
        </div>

        <form method="POST" action="">
            <div class="section-card">
                <div class="section-title">
                    <i class="fas fa-user"></i> Información Personal
                </div>
                
                <div class="form-group">
                    <label class="form-label">Nombre Completo *</label>
                    <input type="text" name="full_name" class="form-input" 
                           value="<?php echo htmlspecialchars($user['full_name'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                    <label class="form-label">Cédula</label>
                    <input type="text" name="cedula" class="form-input" 
                           value="<?php echo htmlspecialchars($user['cedula'] ?? ''); ?>" 
                           placeholder="8-888-8888">
                </div>

                <div class="form-group">
                    <label class="form-label">Teléfono</label>
                    <input type="tel" name="phone" class="form-input" 
                           value="<?php echo htmlspecialchars($user['phone'] ?? ''); ?>" 
                           placeholder="+507 6000-0000">
                </div>

                <div class="form-group">
                    <label class="form-label">Email *</label>
                    <input type="email" name="email" class="form-input" 
                           value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>" required>
                </div>
            </div>

            <div class="section-card">
                <div class="section-title">
                    <i class="fas fa-heartbeat"></i> Información Médica
                </div>

                <div class="form-group">
                    <label class="form-label">Tipo de Sangre</label>
                    <select name="blood_type" class="form-input">
                        <option value="">Seleccionar</option>
                        <?php 
                        $blood_types = ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'];
                        foreach ($blood_types as $type) {
                            $selected = ($user['blood_type'] ?? '') === $type ? 'selected' : '';
                            echo "<option value='$type' $selected>$type</option>";
                        }
                        ?>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label">Alergias</label>
                    <textarea name="allergies" class="form-input" 
                              placeholder="Medicamentos, alimentos, etc."><?php echo htmlspecialchars($user['allergies'] ?? ''); ?></textarea>
                </div>

                <div class="form-group">
                    <label class="form-label">Condiciones Médicas</label>
                    <textarea name="medical_conditions" class="form-input" 
                              placeholder="Diabetes, hipertensión, etc."><?php echo htmlspecialchars($user['medical_conditions'] ?? ''); ?></textarea>
                </div>
            </div>

            <div class="section-card">
                <div class="section-title">
                    <i class="fas fa-phone-alt"></i> Contacto de Emergencia
                </div>

                <div class="form-group">
                    <label class="form-label">Nombre del Contacto</label>
                    <input type="text" name="emergency_contact_name" class="form-input" 
                           value="<?php echo htmlspecialchars($user['emergency_contact_name'] ?? ''); ?>" 
                           placeholder="Familiar o amigo cercano">
                </div>

                <div class="form-group">
                    <label class="form-label">Teléfono del Contacto</label>
                    <input type="tel" name="emergency_contact_phone" class="form-input" 
                           value="<?php echo htmlspecialchars($user['emergency_contact_phone'] ?? ''); ?>" 
                           placeholder="+507 6000-0000">
                </div>
            </div>

            <button type="submit" class="btn-save">
                <i class="fas fa-save"></i> Guardar Cambios
            </button>
        </form>

        <div class="section-card">
            <div class="section-title">
                <i class="fas fa-lock"></i> Seguridad
            </div>
            <button type="button" class="btn-change-password" onclick="alert('Próximamente: Cambio de contraseña')">
                <i class="fas fa-key"></i> Cambiar Contraseña
            </button>
        </div>
    </div>

    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Inicio</span>
        </a>
        <a href="my-alerts.php" class="nav-item">
            <i class="fas fa-bell"></i>
            <span>Alertas</span>
        </a>
        <a href="profile.php" class="nav-item active">
            <i class="fas fa-user"></i>
            <span>Perfil</span>
        </a>
        <a href="settings.php" class="nav-item">
            <i class="fas fa-cog"></i>
            <span>Ajustes</span>
        </a>
    </div>
</body>
</html>
