self.addEventListener('install', (event) => {
    console.log('Service Worker instalado');
    self.skipWaiting();
});

self.addEventListener('activate', (event) => {
    console.log('Service Worker activado');
    event.waitUntil(clients.claim());
});

self.addEventListener('push', (event) => {
    const data = event.data ? event.data.json() : {};
    const title = data.title || 'Azuero Safety';
    const options = {
        body: data.body || 'Nueva notificación',
        icon: 'icons/icon-192x192.png',
        badge: 'icons/icon-72x72.png',
        vibrate: [200, 100, 200],
        data: data.url || '/',
        actions: [
            {
                action: 'open',
                title: 'Ver',
                icon: 'icons/icon-72x72.png'
            },
            {
                action: 'close',
                title: 'Cerrar'
            }
        ],
        requireInteraction: true
    };

    event.waitUntil(
        self.registration.showNotification(title, options)
    );
});

self.addEventListener('notificationclick', (event) => {
    event.notification.close();

    if (event.action === 'open') {
        event.waitUntil(
            clients.openWindow(event.notification.data || '/')
        );
    }
});

// Sincronización en segundo plano
self.addEventListener('sync', (event) => {
    if (event.tag === 'sync-alerts') {
        event.waitUntil(syncAlerts());
    }
});

async function syncAlerts() {
    try {
        const response = await fetch('api-alerts.php?action=recent');
        const data = await response.json();
        
        if (data.success && data.data.length > 0) {
            // Almacenar alertas en caché
            const cache = await caches.open('alerts-cache');
            await cache.put('recent-alerts', new Response(JSON.stringify(data)));
        }
    } catch (error) {
        console.error('Error sincronizando alertas:', error);
    }
}
