<?php
session_start();

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'citizen') {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#667eea">
    <title>Ajustes - Azuero Safety</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f7fa;
            padding-bottom: 80px;
        }

        .header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 15px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .header-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .btn-back {
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            width: 38px;
            height: 38px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            cursor: pointer;
        }

        .header-title h1 {
            font-size: 20px;
            font-weight: 700;
        }

        .container {
            padding: 15px;
        }

        .settings-card {
            background: white;
            border-radius: 14px;
            padding: 18px;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        .settings-title {
            font-size: 15px;
            font-weight: 700;
            color: #333;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .setting-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .setting-item:last-child {
            border-bottom: none;
        }

        .setting-label {
            display: flex;
            flex-direction: column;
        }

        .setting-label strong {
            font-size: 14px;
            color: #333;
            margin-bottom: 3px;
        }

        .setting-label small {
            font-size: 12px;
            color: #999;
        }

        .toggle-switch {
            position: relative;
            width: 50px;
            height: 28px;
        }

        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .toggle-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: #ccc;
            border-radius: 28px;
            transition: 0.3s;
        }

        .toggle-slider:before {
            position: absolute;
            content: "";
            height: 22px;
            width: 22px;
            left: 3px;
            bottom: 3px;
            background: white;
            border-radius: 50%;
            transition: 0.3s;
        }

        input:checked + .toggle-slider {
            background: #667eea;
        }

        input:checked + .toggle-slider:before {
            transform: translateX(22px);
        }

        .select-control {
            padding: 8px 30px 8px 12px;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            font-size: 14px;
            background: white url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23333' d='M6 9L1 4h10z'/%3E%3C/svg%3E") no-repeat right 10px center;
            appearance: none;
            cursor: pointer;
        }

        .action-button {
            width: 100%;
            padding: 14px;
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            transition: all 0.3s;
            margin-bottom: 10px;
        }

        .action-button:active {
            transform: scale(0.98);
        }

        .action-button.danger {
            color: #dc3545;
            border-color: #dc3545;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            padding: 8px 0;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
        }

        .nav-item {
            text-align: center;
            padding: 8px;
            color: #999;
            text-decoration: none;
            transition: all 0.3s;
        }

        .nav-item i {
            font-size: 20px;
            margin-bottom: 4px;
        }

        .nav-item span {
            display: block;
            font-size: 11px;
        }

        .nav-item.active {
            color: #667eea;
        }

        .version-info {
            text-align: center;
            color: #999;
            font-size: 12px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <button class="btn-back" onclick="location.href='dashboard.php'">
                <i class="fas fa-arrow-left"></i>
            </button>
            <div class="header-title">
                <h1>Ajustes</h1>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="settings-card">
            <div class="settings-title">
                <i class="fas fa-bell"></i> Notificaciones
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Notificaciones Push</strong>
                    <small>Recibe alertas en tiempo real</small>
                </div>
                <label class="toggle-switch">
                    <input type="checkbox" id="push-notifications" checked>
                    <span class="toggle-slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Sonido</strong>
                    <small>Reproducir sonido con alertas</small>
                </div>
                <label class="toggle-switch">
                    <input type="checkbox" id="sound" checked>
                    <span class="toggle-slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Vibración</strong>
                    <small>Vibrar al recibir alerta</small>
                </div>
                <label class="toggle-switch">
                    <input type="checkbox" id="vibration" checked>
                    <span class="toggle-slider"></span>
                </label>
            </div>
        </div>

        <div class="settings-card">
            <div class="settings-title">
                <i class="fas fa-map-marker-alt"></i> Ubicación
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>GPS Siempre Activo</strong>
                    <small>Compartir ubicación constantemente</small>
                </div>
                <label class="toggle-switch">
                    <input type="checkbox" id="gps-always">
                    <span class="toggle-slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>GPS en Alertas</strong>
                    <small>Solo al crear alerta</small>
                </div>
                <label class="toggle-switch">
                    <input type="checkbox" id="gps-alerts" checked>
                    <span class="toggle-slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Precisión GPS</strong>
                    <small>Mayor precisión consume más batería</small>
                </div>
                <select class="select-control" id="gps-accuracy">
                    <option value="high">Alta</option>
                    <option value="medium" selected>Media</option>
                    <option value="low">Baja</option>
                </select>
            </div>
        </div>

        <div class="settings-card">
            <div class="settings-title">
                <i class="fas fa-shield-alt"></i> Privacidad
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Perfil Público</strong>
                    <small>Otros usuarios pueden ver tu perfil</small>
                </div>
                <label class="toggle-switch">
                    <input type="checkbox" id="public-profile">
                    <span class="toggle-slider"></span>
                </label>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Compartir Estadísticas</strong>
                    <small>Ayuda a mejorar el servicio</small>
                </div>
                <label class="toggle-switch">
                    <input type="checkbox" id="share-stats" checked>
                    <span class="toggle-slider"></span>
                </label>
            </div>
        </div>

        <div class="settings-card">
            <div class="settings-title">
                <i class="fas fa-globe"></i> Preferencias
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Idioma</strong>
                    <small>Seleccionar idioma de la app</small>
                </div>
                <select class="select-control" id="language">
                    <option value="es" selected>Español</option>
                    <option value="en">English</option>
                </select>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Auto-Actualización</strong>
                    <small>Intervalo de actualización de datos</small>
                </div>
                <select class="select-control" id="auto-refresh">
                    <option value="15">15 segundos</option>
                    <option value="30" selected>30 segundos</option>
                    <option value="60">1 minuto</option>
                    <option value="0">Manual</option>
                </select>
            </div>
        </div>

        <div class="settings-card">
            <div class="settings-title">
                <i class="fas fa-cog"></i> Acciones
            </div>

            <button class="action-button" onclick="clearCache()">
                <i class="fas fa-trash"></i>
                Limpiar Caché
            </button>

            <button class="action-button" onclick="location.href='ver-logs.php'">
                <i class="fas fa-file-alt"></i>
                Ver Logs de Sistema
            </button>

            <button class="action-button danger" onclick="confirmLogout()">
                <i class="fas fa-sign-out-alt"></i>
                Cerrar Sesión
            </button>
        </div>

        <div class="settings-card">
            <div class="settings-title">
                <i class="fas fa-info-circle"></i> Acerca de
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Versión</strong>
                </div>
                <span style="font-size: 14px; color: #666;">1.0.0</span>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Términos de Servicio</strong>
                </div>
                <a href="#" style="color: #667eea; text-decoration: none; font-size: 14px;">Ver</a>
            </div>

            <div class="setting-item">
                <div class="setting-label">
                    <strong>Política de Privacidad</strong>
                </div>
                <a href="#" style="color: #667eea; text-decoration: none; font-size: 14px;">Ver</a>
            </div>
        </div>

        <div class="version-info">
            © 2024 Azuero Safety Mobile<br>
            Versión 1.0.0 - Build 1001
        </div>
    </div>

    <div class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Inicio</span>
        </a>
        <a href="my-alerts.php" class="nav-item">
            <i class="fas fa-bell"></i>
            <span>Alertas</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user"></i>
            <span>Perfil</span>
        </a>
        <a href="settings.php" class="nav-item active">
            <i class="fas fa-cog"></i>
            <span>Ajustes</span>
        </a>
    </div>

    <script>
        // Load saved settings
        document.addEventListener('DOMContentLoaded', function() {
            loadSettings();
            
            // Add change listeners
            document.querySelectorAll('input[type="checkbox"], select').forEach(el => {
                el.addEventListener('change', saveSettings);
            });
        });

        function loadSettings() {
            const settings = JSON.parse(localStorage.getItem('app_settings') || '{}');
            
            Object.keys(settings).forEach(key => {
                const el = document.getElementById(key);
                if (el) {
                    if (el.type === 'checkbox') {
                        el.checked = settings[key];
                    } else {
                        el.value = settings[key];
                    }
                }
            });
        }

        function saveSettings() {
            const settings = {};
            
            document.querySelectorAll('input[type="checkbox"]').forEach(el => {
                settings[el.id] = el.checked;
            });
            
            document.querySelectorAll('select').forEach(el => {
                settings[el.id] = el.value;
            });
            
            localStorage.setItem('app_settings', JSON.stringify(settings));
            
            // Aplicar cambios inmediatamente
            applySettings(settings);
            
            // Show confirmation toast
            showToast('Ajustes guardados y aplicados');
        }

        function applySettings(settings) {
            // Aplicar idioma
            if (settings.language) {
                if (settings.language === 'en') {
                    showToast('Language changed to English (UI translation pending)');
                } else {
                    // Ya está en español
                }
            }

            // Aplicar auto-refresh al dashboard
            if (settings['auto-refresh']) {
                localStorage.setItem('dashboard_refresh_interval', settings['auto-refresh']);
            }

            // Notificaciones
            if (settings['push-notifications']) {
                if ('Notification' in window && Notification.permission === 'default') {
                    Notification.requestPermission().then(permission => {
                        if (permission === 'granted') {
                            showToast('Notificaciones activadas');
                        }
                    });
                }
            }

            // GPS
            if (settings['gps-always']) {
                showToast('GPS siempre activo (consume más batería)');
            } else if (settings['gps-alerts']) {
                showToast('GPS solo en alertas');
            }
        }

        function clearCache() {
            if (confirm('¿Borrar todos los datos en caché?')) {
                localStorage.clear();
                sessionStorage.clear();
                showToast('Caché limpiado');
                setTimeout(() => location.reload(), 1000);
            }
        }

        function confirmLogout() {
            if (confirm('¿Cerrar sesión?')) {
                location.href = 'logout.php';
            }
        }

        function showToast(message) {
            const toast = document.createElement('div');
            toast.style.cssText = 'position:fixed;top:20px;left:50%;transform:translateX(-50%);background:#333;color:white;padding:12px 24px;border-radius:8px;z-index:10000;font-size:14px;';
            toast.textContent = message;
            document.body.appendChild(toast);
            setTimeout(() => toast.remove(), 2000);
        }

        // GPS always vs alerts only - mutual exclusivity
        document.getElementById('gps-always').addEventListener('change', function(e) {
            if (e.target.checked) {
                document.getElementById('gps-alerts').checked = false;
            }
        });

        document.getElementById('gps-alerts').addEventListener('change', function(e) {
            if (e.target.checked) {
                document.getElementById('gps-always').checked = false;
            }
        });
    </script>
</body>
</html>
