-- Tabla para almacenar suscripciones de notificaciones push
CREATE TABLE IF NOT EXISTS `push_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_type` enum('citizen','operator') NOT NULL DEFAULT 'citizen',
  `endpoint` text NOT NULL,
  `keys_json` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_used` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_subscription` (`user_id`,`user_type`,`endpoint`(255)),
  KEY `idx_user` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Actualizar tabla de alertas para soportar campos de operador (si no existen)
ALTER TABLE `alerts` 
ADD COLUMN IF NOT EXISTS `operator_id` int(11) DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `response_time` timestamp NULL DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `resolved_at` timestamp NULL DEFAULT NULL,
ADD COLUMN IF NOT EXISTS `resolution_notes` text,
ADD INDEX IF NOT EXISTS `idx_operator` (`operator_id`),
ADD INDEX IF NOT EXISTS `idx_status` (`status`),
ADD INDEX IF NOT EXISTS `idx_type` (`alert_type`);
