<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Test de Conexión - Azuero Safety Mobile</h2>";

// Test 1: Verificar archivo config.php
echo "<h3>1. Verificando config.php</h3>";
if (file_exists('../config.php')) {
    echo "✅ config.php encontrado en raíz<br>";
    require_once '../config.php';
} elseif (file_exists('config.php')) {
    echo "✅ config.php encontrado en carpeta actual<br>";
    require_once 'config.php';
} else {
    echo "❌ config.php NO encontrado<br>";
    die("ERROR: No se encuentra config.php");
}

// Test 2: Verificar constantes
echo "<h3>2. Verificando constantes de BD</h3>";
if (defined('DB_HOST')) {
    echo "✅ DB_HOST: " . DB_HOST . "<br>";
    echo "✅ DB_NAME: " . DB_NAME . "<br>";
    echo "✅ DB_USER: " . DB_USER . "<br>";
    echo "✅ DB_PASS: " . str_repeat('*', strlen(DB_PASS)) . " (oculta)<br>";
} else {
    echo "❌ Constantes NO definidas<br>";
    die("ERROR: Constantes de BD no están definidas");
}

// Test 3: Intentar conexión
echo "<h3>3. Intentando conexión a MySQL</h3>";
try {
    $pdo = new PDO(
        "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    echo "✅ <strong style='color:green'>CONEXIÓN EXITOSA!</strong><br>";
    
    // Test 4: Verificar tablas
    echo "<h3>4. Verificando tablas</h3>";
    
    $tables = ['users', 'operators', 'alerts'];
    foreach ($tables as $table) {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            $count = $pdo->query("SELECT COUNT(*) FROM $table")->fetchColumn();
            echo "✅ Tabla <strong>$table</strong> existe ($count registros)<br>";
        } else {
            echo "❌ Tabla <strong>$table</strong> NO existe<br>";
        }
    }
    
    // Test 5: Verificar usuario de prueba
    echo "<h3>5. Verificando usuarios de prueba</h3>";
    
    $stmt = $pdo->query("SELECT username, email, full_name FROM operators LIMIT 3");
    $operators = $stmt->fetchAll();
    if ($operators) {
        echo "<strong>Operadores encontrados:</strong><br>";
        foreach ($operators as $op) {
            echo "- Usuario: {$op['username']}, Email: {$op['email']}, Nombre: {$op['full_name']}<br>";
        }
    } else {
        echo "⚠️ No hay operadores en la BD<br>";
    }
    
    $stmt = $pdo->query("SELECT username, email, full_name FROM users LIMIT 3");
    $users = $stmt->fetchAll();
    if ($users) {
        echo "<br><strong>Ciudadanos encontrados:</strong><br>";
        foreach ($users as $user) {
            $username = $user['username'] ?? 'N/A';
            echo "- Usuario: {$username}, Email: {$user['email']}, Nombre: {$user['full_name']}<br>";
        }
    } else {
        echo "⚠️ No hay ciudadanos en la BD<br>";
    }
    
    echo "<h3>✅ DIAGNÓSTICO COMPLETO</h3>";
    echo "<p style='color:green;font-weight:bold'>La conexión funciona correctamente!</p>";
    echo "<p>Si el login sigue fallando, el problema es con las credenciales del usuario.</p>";
    
} catch(PDOException $e) {
    echo "❌ <strong style='color:red'>ERROR DE CONEXIÓN</strong><br>";
    echo "<strong>Código:</strong> " . $e->getCode() . "<br>";
    echo "<strong>Mensaje:</strong> " . $e->getMessage() . "<br><br>";
    
    echo "<h3>Posibles soluciones:</h3>";
    echo "<ul>";
    echo "<li>Verifica que el servidor MySQL esté corriendo</li>";
    echo "<li>Verifica que el host sea correcto (puede ser 'localhost' o una IP)</li>";
    echo "<li>Verifica que el nombre de la base de datos sea correcto</li>";
    echo "<li>Verifica que el usuario tenga permisos en la base de datos</li>";
    echo "<li>Verifica que la contraseña sea correcta</li>";
    echo "</ul>";
}

echo "<hr>";
echo "<p><small>Test realizado el " . date('Y-m-d H:i:s') . "</small></p>";
?>
