-- ACTUALIZACIÓN RÁPIDA DE BASE DE DATOS
-- Ejecuta esto en phpMyAdmin si ya tienes la base instalada

-- Agregar campo language a operators si no existe
ALTER TABLE operators ADD COLUMN IF NOT EXISTS language ENUM('es', 'en') DEFAULT 'es' AFTER role;

-- Agregar campos de contacto emergencia a users si no existen
ALTER TABLE users ADD COLUMN IF NOT EXISTS emergency_contact_name VARCHAR(100) AFTER cedula;
ALTER TABLE users ADD COLUMN IF NOT EXISTS emergency_contact_phone VARCHAR(20) AFTER emergency_contact_name;
ALTER TABLE users ADD COLUMN IF NOT EXISTS emergency_contact_relation VARCHAR(50) AFTER emergency_contact_phone;
ALTER TABLE users ADD COLUMN IF NOT EXISTS current_medications TEXT AFTER medical_conditions;

-- Crear tabla service_codes si no existe
CREATE TABLE IF NOT EXISTS service_codes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(12) UNIQUE NOT NULL,
    created_by INT NOT NULL,
    assigned_to INT DEFAULT NULL,
    status ENUM('available', 'assigned', 'expired') DEFAULT 'available',
    expires_at DATE NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (created_by) REFERENCES operators(id),
    FOREIGN KEY (assigned_to) REFERENCES users(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertar códigos de servicio de ejemplo si la tabla está vacía
INSERT INTO service_codes (code, created_by, status, expires_at)
SELECT 'SC-2025-0001', 1, 'assigned', DATE_ADD(NOW(), INTERVAL 1 YEAR)
WHERE NOT EXISTS (SELECT 1 FROM service_codes WHERE code = 'SC-2025-0001');

INSERT INTO service_codes (code, created_by, status, expires_at)
SELECT 'SC-2025-0002', 1, 'available', DATE_ADD(NOW(), INTERVAL 1 YEAR)
WHERE NOT EXISTS (SELECT 1 FROM service_codes WHERE code = 'SC-2025-0002');

INSERT INTO service_codes (code, created_by, status, expires_at)
SELECT 'SC-2025-0003', 1, 'available', DATE_ADD(NOW(), INTERVAL 1 YEAR)
WHERE NOT EXISTS (SELECT 1 FROM service_codes WHERE code = 'SC-2025-0003');

INSERT INTO service_codes (code, created_by, status, expires_at)
SELECT 'SC-2025-0004', 1, 'available', DATE_ADD(NOW(), INTERVAL 1 YEAR)
WHERE NOT EXISTS (SELECT 1 FROM service_codes WHERE code = 'SC-2025-0004');

INSERT INTO service_codes (code, created_by, status, expires_at)
SELECT 'SC-2025-0005', 1, 'available', DATE_ADD(NOW(), INTERVAL 1 YEAR)
WHERE NOT EXISTS (SELECT 1 FROM service_codes WHERE code = 'SC-2025-0005');

-- Verificar los cambios
SELECT 'Códigos de servicio creados:' as mensaje, COUNT(*) as total FROM service_codes;
SELECT 'Códigos disponibles:' as mensaje, COUNT(*) as total FROM service_codes WHERE status = 'available';
