-- PASO 1: Copia y pega este código completo en phpMyAdmin
-- Ve a tu base de datos u793455123_azuero_safety y pega esto en la pestaña SQL

-- Crear tabla de operadores
CREATE TABLE IF NOT EXISTS operators (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    phone VARCHAR(20),
    role ENUM('admin', 'supervisor', 'operator') DEFAULT 'operator',
    language ENUM('es', 'en') DEFAULT 'es',
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Crear tabla de usuarios (ciudadanos)
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    service_code VARCHAR(12) UNIQUE NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    phone VARCHAR(20) NOT NULL,
    cedula VARCHAR(20) UNIQUE,
    password VARCHAR(255),
    emergency_contact_name VARCHAR(100),
    emergency_contact_phone VARCHAR(20),
    emergency_contact_relation VARCHAR(50),
    blood_type VARCHAR(5),
    allergies TEXT,
    medical_conditions TEXT,
    current_medications TEXT,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Crear tabla de alertas
CREATE TABLE IF NOT EXISTS alerts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    alert_type VARCHAR(50) NOT NULL,
    priority ENUM('low', 'medium', 'high') DEFAULT 'medium',
    status ENUM('pending', 'in_progress', 'resolved', 'cancelled') DEFAULT 'pending',
    latitude DECIMAL(10, 8),
    longitude DECIMAL(11, 8),
    location_name VARCHAR(255),
    description TEXT,
    photo_url VARCHAR(255),
    video_url VARCHAR(255),
    audio_url VARCHAR(255),
    assigned_operator_id INT,
    response_time DATETIME,
    resolved_at DATETIME,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (assigned_operator_id) REFERENCES operators(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertar operador admin (usuario: admin, contraseña: password123)
INSERT INTO operators (username, password, full_name, email, role, status) VALUES
('admin', '$2y$10$FtMWBChKpefZ9KCzhPo3JOU.hO3vLvsk06OZYB2SUjfOnVtwhlpF2', 'Administrador del Sistema', 'admin@azuerosafety.com', 'admin', 'active');

-- Insertar usuario de prueba
INSERT INTO users (service_code, full_name, email, phone, cedula, blood_type, emergency_contact_name, emergency_contact_phone, emergency_contact_relation) VALUES
('SC-2025-0001', 'Juan Pérez', 'juan@example.com', '+507 6000-0000', '8-123-456', 'O+', 'María Pérez', '+507 6111-1111', 'Hermana');

-- Insertar alertas de ejemplo
INSERT INTO alerts (user_id, alert_type, priority, status, latitude, longitude, location_name, description) VALUES
(1, 'medical', 'high', 'pending', 7.5500, -80.9833, 'Chitré Centro', 'Persona con dificultad respiratoria'),
(1, 'fire', 'high', 'in_progress', 7.5600, -80.9900, 'Parque Central', 'Incendio en vivienda'),
(1, 'crime', 'medium', 'resolved', 7.5450, -80.9750, 'Barrio San Juan', 'Robo reportado');

-- Crear tabla de códigos de servicio
CREATE TABLE IF NOT EXISTS service_codes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(12) UNIQUE NOT NULL,
    created_by INT NOT NULL,
    assigned_to INT NULL,
    status ENUM('available', 'assigned', 'expired') DEFAULT 'available',
    expires_at DATETIME NOT NULL,
    assigned_at DATETIME,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (created_by) REFERENCES operators(id) ON DELETE CASCADE,
    FOREIGN KEY (assigned_to) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertar códigos de servicio de ejemplo (expiran en 1 año)
INSERT INTO service_codes (code, created_by, status, assigned_to, expires_at) VALUES
('SC-2025-0001', 1, 'assigned', 1, DATE_ADD(NOW(), INTERVAL 1 YEAR)),
('SC-2025-0002', 1, 'available', NULL, DATE_ADD(NOW(), INTERVAL 1 YEAR)),
('SC-2025-0003', 1, 'available', NULL, DATE_ADD(NOW(), INTERVAL 1 YEAR)),
('SC-2025-0004', 1, 'available', NULL, DATE_ADD(NOW(), INTERVAL 1 YEAR)),
('SC-2025-0005', 1, 'available', NULL, DATE_ADD(NOW(), INTERVAL 1 YEAR));
