-- ================================================================
-- ACTUALIZACIÓN DE BASE DE DATOS - 3 MEJORAS PRINCIPALES
-- Azuero Safety Services S.A
-- ================================================================
-- Este script agrega las características necesarias para:
-- 1. Login con 3 campos (email, username, password)
-- 2. Remember Me persistente
-- 3. Idioma persistente por usuario
-- ================================================================
-- IMPORTANTE: Este script NO usa "USE database" para evitar errores
-- Ejecuta este script mientras estás DENTRO de tu base de datos en phpMyAdmin
-- ================================================================

-- ================================================================
-- 1. AGREGAR COLUMNAS A TABLA USERS (CIUDADANOS)
-- ================================================================

-- Agregar columna username si no existe (obligatorio para login)
ALTER TABLE users 
ADD COLUMN IF NOT EXISTS username VARCHAR(50) UNIQUE AFTER id;

-- Agregar columna password si no existe
ALTER TABLE users 
ADD COLUMN IF NOT EXISTS password VARCHAR(255) AFTER username;

-- Agregar columna remember_token para Remember Me
ALTER TABLE users 
ADD COLUMN IF NOT EXISTS remember_token VARCHAR(255) NULL AFTER password;

-- Agregar columna language para idioma persistente
ALTER TABLE users 
ADD COLUMN IF NOT EXISTS language ENUM('en', 'es') DEFAULT 'en' AFTER remember_token;

-- ================================================================
-- 2. AGREGAR COLUMNAS A TABLA OPERATORS (OPERADORES)
-- ================================================================

-- Agregar columna remember_token para Remember Me
ALTER TABLE operators 
ADD COLUMN IF NOT EXISTS remember_token VARCHAR(255) NULL AFTER password;

-- Agregar columna language si no existe
ALTER TABLE operators 
ADD COLUMN IF NOT EXISTS language ENUM('en', 'es') DEFAULT 'en' AFTER remember_token;

-- Agregar columna last_login si no existe
ALTER TABLE operators 
ADD COLUMN IF NOT EXISTS last_login TIMESTAMP NULL AFTER language;

-- ================================================================
-- 3. MIGRAR DATOS EXISTENTES
-- ================================================================

-- Generar usernames automáticos para usuarios existentes que no tengan
UPDATE users 
SET username = CONCAT('user', id) 
WHERE username IS NULL OR username = '';

-- Generar passwords temporales para usuarios sin contraseña (hash de "Temp1234!")
UPDATE users 
SET password = '$2y$10$FtMWBChKpefZ9KCzhPo3JOU.hO3vLvsk06OZYB2SUjfOnVtwhlpF2'
WHERE password IS NULL OR password = '';

-- Establecer idioma inglés por defecto para clientes norteamericanos
UPDATE users 
SET language = 'en' 
WHERE language IS NULL OR language = '';

UPDATE operators 
SET language = 'en' 
WHERE language IS NULL OR language = '';

-- ================================================================
-- 4. VERIFICACIÓN DE DATOS
-- ================================================================

-- Verificar que todos los usuarios tengan username único
SELECT 
    'USERS - Verificación de Username' as tabla,
    COUNT(*) as total,
    COUNT(DISTINCT username) as usernames_unicos,
    COUNT(*) - COUNT(DISTINCT username) as duplicados
FROM users;

-- Verificar que todos los operadores tengan datos completos
SELECT 
    'OPERATORS - Verificación de Datos' as tabla,
    COUNT(*) as total,
    SUM(CASE WHEN username IS NOT NULL THEN 1 ELSE 0 END) as con_username,
    SUM(CASE WHEN email IS NOT NULL THEN 1 ELSE 0 END) as con_email,
    SUM(CASE WHEN language IS NOT NULL THEN 1 ELSE 0 END) as con_idioma
FROM operators;

-- ================================================================
-- 5. CREAR ÍNDICES PARA OPTIMIZACIÓN
-- ================================================================

-- Índice para búsqueda rápida por email
CREATE INDEX IF NOT EXISTS idx_users_email ON users(email);
CREATE INDEX IF NOT EXISTS idx_users_username ON users(username);
CREATE INDEX IF NOT EXISTS idx_users_remember_token ON users(remember_token);

CREATE INDEX IF NOT EXISTS idx_operators_email ON operators(email);
CREATE INDEX IF NOT EXISTS idx_operators_username ON operators(username);
CREATE INDEX IF NOT EXISTS idx_operators_remember_token ON operators(remember_token);

-- ================================================================
-- 6. ACTUALIZAR OPERADOR ADMIN PARA TESTING
-- ================================================================

-- Actualizar admin con todos los campos necesarios
UPDATE operators 
SET 
    language = 'en',
    email = 'admin@azuerosafety.com',
    username = 'admin'
WHERE id = 1 OR username = 'admin';

-- ================================================================
-- 7. CREAR USUARIOS DE PRUEBA (OPCIONAL)
-- ================================================================

-- Insertar usuario de prueba con todos los campos
-- Email: test@example.com | Username: testuser | Password: Test1234!
INSERT INTO users (username, password, full_name, email, phone, status, language, created_at) 
VALUES (
    'testuser', 
    '$2y$10$RGYvKb3z7XkJKlPtXPYf5eBJbZJVRX3aP5nLXW2zqJGX6yL0Mjqxe', 
    'Test User', 
    'test@example.com', 
    '+507 6000-0001', 
    'active', 
    'en', 
    NOW()
)
ON DUPLICATE KEY UPDATE 
    password = '$2y$10$RGYvKb3z7XkJKlPtXPYf5eBJbZJVRX3aP5nLXW2zqJGX6yL0Mjqxe',
    language = 'en';

-- Insertar operador de prueba
-- Email: operator@azuerosafety.com | Username: operator | Password: Oper1234!
INSERT INTO operators (username, password, full_name, email, role, status, language, created_at) 
VALUES (
    'operator', 
    '$2y$10$mF8YH5JQw8KlPZxPQYf5eBJbZJVRX3aP5nLXW2zqJGX6yL0Mjqxe', 
    'Test Operator', 
    'operator@azuerosafety.com', 
    'operator', 
    'active', 
    'en', 
    NOW()
)
ON DUPLICATE KEY UPDATE 
    password = '$2y$10$mF8YH5JQw8KlPZxPQYf5eBJbZJVRX3aP5nLXW2zqJGX6yL0Mjqxe',
    language = 'en';

-- ================================================================
-- RESUMEN DE CAMBIOS
-- ================================================================
SELECT '✅ ACTUALIZACIÓN COMPLETADA' as status;
SELECT '1. Login con 3 campos: Email + Username + Password' as feature_1;
SELECT '2. Remember Me con cookies de 30 días' as feature_2;
SELECT '3. Idioma persistente (Inglés por defecto)' as feature_3;
SELECT 'IMPORTANTE: Notificar a usuarios existentes su username y contraseña temporal: Temp1234!' as nota_importante;

-- ================================================================
-- CREDENCIALES DE PRUEBA
-- ================================================================
SELECT '=== CREDENCIALES DE PRUEBA ===' as titulo;
SELECT 'Admin' as tipo, 'admin@azuerosafety.com' as email, 'admin' as username, 'password123' as password;
SELECT 'Operador' as tipo, 'operator@azuerosafety.com' as email, 'operator' as username, 'Oper1234!' as password;
SELECT 'Usuario' as tipo, 'test@example.com' as email, 'testuser' as username, 'Test1234!' as password;
