<?php
require_once 'config.php';
header('Content-Type: application/json');

// Verificar que sea un ciudadano logueado
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'citizen') {
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

$last_check = $_GET['last_check'] ?? 0;

try {
    // Obtener alertas del ciudadano que han tenido actualizaciones
    <?php
    require_once 'config.php';
    header('Content-Type: application/json');

    // Verificar que sea un ciudadano logueado
    if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'citizen') {
        echo json_encode(['error' => 'No autorizado']);
        exit;
    }

    $last_check = isset($_GET['last_check']) ? (int)$_GET['last_check'] : 0;

    try {
        // Obtener alertas del ciudadano que han tenido actualizaciones desde last_check
        $stmt = $conn->prepare("\r
            SELECT \r
                a.id,\r
                a.alert_type,\r
                a.priority,\r
                a.status,\r
                a.description,\r
                a.created_at,\r
                a.updated_at,\r
                a.notes AS operator_response,\r
                o.full_name AS operator_name,\r
                UNIX_TIMESTAMP(a.updated_at) as update_timestamp\r
            FROM alerts a\r
            LEFT JOIN operators o ON a.assigned_operator_id = o.id\r
            WHERE a.user_id = ?\r
              AND UNIX_TIMESTAMP(a.updated_at) > ?\r
            ORDER BY a.updated_at DESC\r
        ");
        $stmt->execute([$_SESSION['user_id'], $last_check]);
        $updated_alerts = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Obtener todas las alertas activas del usuario (pendientes o en progreso)
        $stmt = $conn->prepare("\r
            SELECT \r
                a.id,\r
                a.alert_type,\r
                a.priority,\r
                a.status,\r
                a.description,\r
                a.created_at,\r
                a.notes AS operator_response,\r
                o.full_name as operator_name\r
            FROM alerts a\r
            LEFT JOIN operators o ON a.assigned_operator_id = o.id\r
            WHERE a.user_id = ?\r
              AND a.status IN ('pending', 'in_progress')\r
            ORDER BY a.created_at DESC\r
        ");
        $stmt->execute([$_SESSION['user_id']]);
        $active_alerts = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            'success' => true,
            'has_updates' => count($updated_alerts) > 0,
            'updated_alerts' => $updated_alerts,
            'active_alerts' => $active_alerts,
            'timestamp' => time()
        ]);
    
    } catch(PDOException $e) {
        echo json_encode(['error' => $e->getMessage()]);
    }
    ?>
