<?php
require_once 'config.php';
header('Content-Type: application/json');

// Verificar que sea un operador logueado
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'operator') {
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

// Obtener el timestamp de la última verificación (enviado por el cliente)
$last_check = $_GET['last_check'] ?? 0;

try {
    // Contar alertas nuevas desde la última verificación
    $stmt = $conn->prepare("
        SELECT COUNT(*) as new_count 
        FROM alerts 
        WHERE status = 'pending' 
        AND UNIX_TIMESTAMP(created_at) > ?
    ");
    $stmt->execute([$last_check]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Obtener todas las alertas recientes (últimas 20)
    $stmt = $conn->prepare("
        SELECT a.id, a.alert_type, a.priority, a.status, a.location_name, a.description, a.created_at,
               a.latitude, a.longitude,
               u.full_name, u.phone, u.email,
               UNIX_TIMESTAMP(a.created_at) as timestamp
        FROM alerts a
        LEFT JOIN users u ON a.user_id = u.id
        ORDER BY a.created_at DESC
        LIMIT 20
    ");
    $stmt->execute();
    $recent_alerts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Contar total de alertas por estado (hoy)
    $stmt = $conn->query("
        SELECT 
            COUNT(*) as total,
            COALESCE(SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END), 0) as pending,
            COALESCE(SUM(CASE WHEN status = 'in_progress' THEN 1 ELSE 0 END), 0) as in_progress,
            COALESCE(SUM(CASE WHEN status = 'resolved' THEN 1 ELSE 0 END), 0) as resolved
        FROM alerts
        WHERE DATE(created_at) = CURDATE()
    ");
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Asegurar que todos los valores sean números
    $stats['total'] = intval($stats['total']);
    $stats['pending'] = intval($stats['pending']);
    $stats['in_progress'] = intval($stats['in_progress']);
    $stats['resolved'] = intval($stats['resolved']);
    
    echo json_encode([
        'success' => true,
        'has_new' => $result['new_count'] > 0,
        'new_count' => intval($result['new_count']),
        'alerts' => $recent_alerts,
        'stats' => $stats,
        'timestamp' => time()
    ]);
    
} catch(PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
