-- Base de datos para Azuero Safety (Simple)
-- Ejecuta este script en phpMyAdmin o MySQL

CREATE DATABASE IF NOT EXISTS azuero_safety CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

USE azuero_safety;

-- Tabla de operadores
CREATE TABLE IF NOT EXISTS operators (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    phone VARCHAR(20),
    role ENUM('admin', 'supervisor', 'operator') DEFAULT 'operator',
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabla de usuarios (ciudadanos)
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    phone VARCHAR(20) NOT NULL,
    cedula VARCHAR(20) UNIQUE,
    emergency_contact VARCHAR(100),
    emergency_phone VARCHAR(20),
    blood_type VARCHAR(5),
    allergies TEXT,
    medical_conditions TEXT,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabla de alertas
CREATE TABLE IF NOT EXISTS alerts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    alert_type VARCHAR(50) NOT NULL,
    priority ENUM('low', 'medium', 'high') DEFAULT 'medium',
    status ENUM('pending', 'in_progress', 'resolved', 'cancelled') DEFAULT 'pending',
    latitude DECIMAL(10, 8),
    longitude DECIMAL(11, 8),
    location_name VARCHAR(255),
    description TEXT,
    photo_url VARCHAR(255),
    video_url VARCHAR(255),
    audio_url VARCHAR(255),
    assigned_operator_id INT,
    response_time DATETIME,
    resolved_at DATETIME,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (assigned_operator_id) REFERENCES operators(id) ON DELETE SET NULL
);

-- Insertar operador de prueba
-- Usuario: admin
-- Contraseña: password123
INSERT INTO operators (username, password, full_name, email, role, status) VALUES
('admin', '$2y$10$FtMWBChKpefZ9KCzhPo3JOU.hO3vLvsk06OZYB2SUjfOnVtwhlpF2', 'Administrador del Sistema', 'admin@azuerosafety.com', 'admin', 'active');

-- Insertar usuario de prueba
INSERT INTO users (full_name, email, phone, cedula, blood_type) VALUES
('Juan Pérez', 'juan@example.com', '+507 6000-0000', '8-123-456', 'O+');

-- Insertar alertas de prueba
INSERT INTO alerts (user_id, alert_type, priority, status, latitude, longitude, location_name, description) VALUES
(1, 'medical', 'high', 'pending', 7.5500, -80.9833, 'Chitré Centro', 'Persona con dificultad respiratoria'),
(1, 'fire', 'high', 'in_progress', 7.5600, -80.9900, 'Parque Central', 'Incendio en vivienda'),
(1, 'crime', 'medium', 'resolved', 7.5450, -80.9750, 'Barrio San Juan', 'Robo reportado');
