<?php
require_once 'config.php';

$redirect = 'index.php';
if (isset($_GET['type']) && $_GET['type'] == 'citizen') {
    $redirect = 'ciudadano-login.php';
}

// Limpiar token de remember me de la base de datos
if (isset($_SESSION['user_id']) && isset($_SESSION['user_type'])) {
    try {
        if ($_SESSION['user_type'] == 'operator' && isset($_SESSION['operator_id'])) {
            $stmt = $conn->prepare("UPDATE operators SET remember_token = NULL WHERE id = ?");
            $stmt->execute([$_SESSION['operator_id']]);
        } elseif ($_SESSION['user_type'] == 'citizen') {
            $stmt = $conn->prepare("UPDATE users SET remember_token = NULL WHERE id = ?");
            $stmt->execute([$_SESSION['user_id']]);
        }
    } catch (PDOException $e) {
        // Ignorar errores
    }
}

// Eliminar cookie de remember me
if (isset($_COOKIE['remember_token'])) {
    setcookie('remember_token', '', time() - 3600, '/', '', false, true);
}

session_destroy();
header('Location: ' . $redirect);
exit;
?>
