<?php
/**
 * Script de Migración de Base de Datos
 * Ejecutar SOLO UNA VEZ para actualizar la estructura
 */

require_once 'config.php';

echo "<h2>🔄 Migración de Base de Datos</h2>";
echo "<hr>";

try {
    // 1. Agregar columna last_login si no existe
    echo "<h3>1️⃣ Verificando columna last_login en operators...</h3>";
    try {
        $stmt = $conn->query("SHOW COLUMNS FROM operators LIKE 'last_login'");
        if ($stmt->rowCount() == 0) {
            $conn->exec("ALTER TABLE operators ADD COLUMN last_login TIMESTAMP NULL DEFAULT NULL");
            echo "✅ Columna last_login agregada correctamente<br>";
        } else {
            echo "✅ Columna last_login ya existe<br>";
        }
    } catch (PDOException $e) {
        echo "⚠️ Error con last_login: " . $e->getMessage() . "<br>";
    }
    
    // 2. Verificar que exista la columna username
    echo "<h3>2️⃣ Verificando columna username en operators...</h3>";
    try {
        $stmt = $conn->query("SHOW COLUMNS FROM operators LIKE 'username'");
        if ($stmt->rowCount() == 0) {
            // Si no existe, crearla
            $conn->exec("ALTER TABLE operators ADD COLUMN username VARCHAR(50) UNIQUE");
            echo "✅ Columna username agregada<br>";
            
            // Generar usernames para operadores existentes
            $stmt = $conn->query("SELECT id, email FROM operators WHERE username IS NULL OR username = ''");
            $operators = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($operators as $op) {
                $username = strtolower(explode('@', $op['email'])[0]);
                $baseUsername = $username;
                $counter = 1;
                
                // Verificar que sea único
                while (true) {
                    $checkStmt = $conn->prepare("SELECT id FROM operators WHERE username = ?");
                    $checkStmt->execute([$username]);
                    if ($checkStmt->rowCount() == 0) break;
                    $username = $baseUsername . $counter;
                    $counter++;
                }
                
                $updateStmt = $conn->prepare("UPDATE operators SET username = ? WHERE id = ?");
                $updateStmt->execute([$username, $op['id']]);
                echo "➡️ Username generado para operador #{$op['id']}: {$username}<br>";
            }
        } else {
            echo "✅ Columna username ya existe<br>";
        }
    } catch (PDOException $e) {
        echo "⚠️ Error con username: " . $e->getMessage() . "<br>";
    }
    
    // 3. Verificar columna full_name
    echo "<h3>3️⃣ Verificando columna full_name en operators...</h3>";
    try {
        $stmt = $conn->query("SHOW COLUMNS FROM operators LIKE 'full_name'");
        if ($stmt->rowCount() == 0) {
            $conn->exec("ALTER TABLE operators ADD COLUMN full_name VARCHAR(100) NOT NULL DEFAULT 'Usuario'");
            echo "✅ Columna full_name agregada<br>";
        } else {
            echo "✅ Columna full_name ya existe<br>";
        }
    } catch (PDOException $e) {
        echo "⚠️ Error con full_name: " . $e->getMessage() . "<br>";
    }
    
    // 4. Asegurar que el admin tiene username
    echo "<h3>4️⃣ Verificando usuario admin...</h3>";
    $stmt = $conn->query("SELECT * FROM operators WHERE role = 'admin' LIMIT 1");
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($admin) {
        echo "✅ Usuario admin encontrado (ID: {$admin['id']})<br>";
        echo "📧 Email: {$admin['email']}<br>";
        
        if (empty($admin['username'])) {
            $conn->prepare("UPDATE operators SET username = 'admin' WHERE id = ?")->execute([$admin['id']]);
            echo "✅ Username 'admin' asignado<br>";
        } else {
            echo "✅ Username: {$admin['username']}<br>";
        }
    } else {
        echo "⚠️ No se encontró usuario admin<br>";
        echo "➡️ Creando usuario admin...<br>";
        
        $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
        $stmt = $conn->prepare("
            INSERT INTO operators (username, full_name, email, password, role, status, created_at)
            VALUES ('admin', 'Administrador del Sistema', 'admin@azuerosafety.com', ?, 'admin', 'active', NOW())
        ");
        $stmt->execute([$hashedPassword]);
        
        echo "✅ Usuario admin creado<br>";
        echo "📝 Username: admin<br>";
        echo "🔑 Password: admin123<br>";
    }
    
    echo "<hr>";
    echo "<h3>✅ Migración completada exitosamente</h3>";
    echo "<p><strong>Próximo paso:</strong> Ve a <a href='index.php'>Login</a></p>";
    echo "<p>Usa estas credenciales:</p>";
    echo "<ul>";
    echo "<li><strong>Username:</strong> admin (o tu email)</li>";
    echo "<li><strong>Password:</strong> tu contraseña actual (o admin123 si es nuevo)</li>";
    echo "</ul>";
    
} catch (PDOException $e) {
    echo "<div style='background: #ffebee; color: #c62828; padding: 15px; border-radius: 8px;'>";
    echo "❌ Error: " . $e->getMessage();
    echo "</div>";
}
?>

<style>
    body { 
        font-family: Arial, sans-serif; 
        max-width: 800px; 
        margin: 50px auto; 
        padding: 20px;
        background: #f5f5f5;
    }
    h2 { color: #1e3c72; }
    h3 { color: #2a5298; margin-top: 20px; }
    hr { margin: 30px 0; }
    a {
        color: #1e3c72;
        text-decoration: none;
        font-weight: bold;
    }
    a:hover {
        text-decoration: underline;
    }
    ul {
        background: white;
        padding: 20px 40px;
        border-radius: 8px;
        margin-top: 10px;
    }
    li {
        margin: 10px 0;
    }
</style>
