<?php
require_once 'config.php';

// Verificar que sea operador
if (!isset($_SESSION['operator_id'])) {
    header('Location: index.php');
    exit;
}

// Obtener operador actual
$stmt = $conn->prepare("SELECT role FROM operators WHERE id = ?");
$stmt->execute([$_SESSION['operator_id']]);
$operator = $stmt->fetch(PDO::FETCH_ASSOC);
$isAdmin = $operator['role'] === 'admin';

// Si no es admin, redirigir
if (!$isAdmin) {
    header('Location: admin-panel.php');
    exit;
}

// Procesar acciones de edición
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $type = $_POST['type'] ?? '';
    
    if ($action === 'edit') {
        if ($type === 'user') {
            $userId = $_POST['user_id'] ?? 0;
            $fullName = trim($_POST['full_name'] ?? '');
            $email = trim($_POST['email'] ?? '');
            $phone = trim($_POST['phone'] ?? '');
            $newPassword = trim($_POST['password'] ?? '');
            
            if (!$userId || empty($fullName) || empty($email)) {
                $message = 'Faltan campos requeridos';
                $messageType = 'error';
            } else {
                try {
                    if (!empty($newPassword)) {
                        $hashed = password_hash($newPassword, PASSWORD_DEFAULT);
                        $stmt = $conn->prepare("UPDATE users SET full_name = ?, email = ?, phone = ?, password = ? WHERE id = ?");
                        $stmt->execute([$fullName, $email, $phone, $hashed, $userId]);
                        $message = "✅ Usuario actualizado. Contraseña: $newPassword";
                    } else {
                        $stmt = $conn->prepare("UPDATE users SET full_name = ?, email = ?, phone = ? WHERE id = ?");
                        $stmt->execute([$fullName, $email, $phone, $userId]);
                        $message = "✅ Usuario actualizado";
                    }
                    $messageType = 'success';
                } catch (PDOException $e) {
                    $message = "Error: " . $e->getMessage();
                    $messageType = 'error';
                }
            }
        } elseif ($type === 'operator') {
            $operatorId = $_POST['operator_id'] ?? 0;
            $fullName = trim($_POST['full_name'] ?? '');
            $email = trim($_POST['email'] ?? '');
            $newPassword = trim($_POST['password'] ?? '');
            
            if (!$operatorId || empty($fullName) || empty($email)) {
                $message = 'Faltan campos requeridos';
                $messageType = 'error';
            } else {
                try {
                    if (!empty($newPassword)) {
                        $hashed = password_hash($newPassword, PASSWORD_DEFAULT);
                        $stmt = $conn->prepare("UPDATE operators SET full_name = ?, email = ?, password = ? WHERE id = ?");
                        $stmt->execute([$fullName, $email, $hashed, $operatorId]);
                        $message = "✅ Operador actualizado. Contraseña: $newPassword";
                    } else {
                        $stmt = $conn->prepare("UPDATE operators SET full_name = ?, email = ? WHERE id = ?");
                        $stmt->execute([$fullName, $email, $operatorId]);
                        $message = "✅ Operador actualizado";
                    }
                    $messageType = 'success';
                } catch (PDOException $e) {
                    $message = "Error: " . $e->getMessage();
                    $messageType = 'error';
                }
            }
        }
    }
}

// Obtener todos los usuarios
$stmt = $conn->query("SELECT id, full_name, email, phone, status, created_at FROM users ORDER BY created_at DESC");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtener todos los operadores
$stmt = $conn->query("SELECT id, full_name, email, role, status, created_at FROM operators ORDER BY created_at DESC");
$operators = $stmt->fetchAll(PDO::FETCH_ASSOC);

$selectedType = $_GET['type'] ?? 'users';
$selectedId = $_GET['id'] ?? null;
$editData = null;

if ($selectedType === 'users' && $selectedId) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$selectedId]);
    $editData = $stmt->fetch(PDO::FETCH_ASSOC);
} elseif ($selectedType === 'operators' && $selectedId) {
    $stmt = $conn->prepare("SELECT * FROM operators WHERE id = ?");
    $stmt->execute([$selectedId]);
    $editData = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Usuarios y Operadores</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1400px;
            margin: 0 auto;
        }
        .header {
            background: white;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 {
            color: #333;
            font-size: 24px;
        }
        .back-btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        .back-btn:hover {
            background: #5568d3;
        }
        .tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        .tab-btn {
            background: white;
            padding: 12px 24px;
            border: 2px solid #ddd;
            border-radius: 5px;
            cursor: pointer;
            font-size: 15px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .tab-btn.active {
            background: #667eea;
            color: white;
            border-color: #667eea;
        }
        .tab-btn:hover {
            border-color: #667eea;
        }
        .content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        .list-section {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-height: 80vh;
            overflow-y: auto;
        }
        .edit-section {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .user-item {
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 10px;
            cursor: pointer;
            transition: all 0.3s;
            background: #f9f9f9;
        }
        .user-item:hover {
            background: #667eea;
            color: white;
            border-color: #667eea;
        }
        .user-item.selected {
            background: #667eea;
            color: white;
            border-color: #667eea;
        }
        .user-name {
            font-weight: 600;
            margin-bottom: 4px;
        }
        .user-email {
            font-size: 13px;
            opacity: 0.8;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            font-weight: 600;
            margin-bottom: 6px;
            color: #333;
        }
        input {
            width: 100%;
            padding: 10px;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        button {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 5px;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s;
            width: 100%;
            margin-top: 10px;
        }
        button:hover {
            background: #5568d3;
        }
        .message {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            display: none;
        }
        .message.show {
            display: block;
        }
        .message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .no-selection {
            padding: 40px;
            text-align: center;
            color: #999;
        }
        @media (max-width: 1024px) {
            .content {
                grid-template-columns: 1fr;
            }
            .list-section {
                max-height: 400px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔐 Gestión de Usuarios y Operadores</h1>
            <a href="admin-panel.php" class="back-btn">
                <i class="fas fa-arrow-left"></i> Volver
            </a>
        </div>

        <div class="tabs">
            <button class="tab-btn <?php echo $selectedType === 'users' ? 'active' : ''; ?>" onclick="switchTab('users')">
                👥 Usuarios (<?php echo count($users); ?>)
            </button>
            <button class="tab-btn <?php echo $selectedType === 'operators' ? 'active' : ''; ?>" onclick="switchTab('operators')">
                🚨 Operadores (<?php echo count($operators); ?>)
            </button>
        </div>

        <?php if ($message): ?>
        <div class="message show <?php echo $messageType; ?>">
            <?php echo htmlspecialchars($message); ?>
        </div>
        <?php endif; ?>

        <div class="content">
            <div class="list-section">
                <h3>Lista</h3>
                <div id="listContainer">
                    <?php if ($selectedType === 'users'): ?>
                        <?php foreach ($users as $user): ?>
                        <div class="user-item <?php echo ($selectedId == $user['id']) ? 'selected' : ''; ?>" 
                             onclick="selectUser('users', <?php echo $user['id']; ?>)">
                            <div class="user-name"><?php echo htmlspecialchars($user['full_name']); ?></div>
                            <div class="user-email"><?php echo htmlspecialchars($user['email']); ?></div>
                            <small style="opacity: 0.6;">Tel: <?php echo htmlspecialchars($user['phone'] ?? 'N/A'); ?></small>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <?php foreach ($operators as $op): ?>
                        <div class="user-item <?php echo ($selectedId == $op['id']) ? 'selected' : ''; ?>" 
                             onclick="selectUser('operators', <?php echo $op['id']; ?>)">
                            <div class="user-name"><?php echo htmlspecialchars($op['full_name']); ?></div>
                            <div class="user-email"><?php echo htmlspecialchars($op['email']); ?></div>
                            <small style="opacity: 0.6;">Rol: <?php echo $op['role']; ?></small>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <div class="edit-section">
                <?php if ($editData): ?>
                    <h3>Editar <?php echo $selectedType === 'users' ? 'Usuario' : 'Operador'; ?></h3>
                    <form method="POST">
                        <input type="hidden" name="action" value="edit">
                        <input type="hidden" name="type" value="<?php echo $selectedType; ?>">
                        <input type="hidden" name="<?php echo $selectedType === 'users' ? 'user_id' : 'operator_id'; ?>" 
                               value="<?php echo $editData['id']; ?>">
                        
                        <div class="form-group">
                            <label>Nombre Completo</label>
                            <input type="text" name="full_name" value="<?php echo htmlspecialchars($editData['full_name']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" value="<?php echo htmlspecialchars($editData['email']); ?>" required>
                        </div>
                        
                        <?php if ($selectedType === 'users'): ?>
                        <div class="form-group">
                            <label>Teléfono</label>
                            <input type="tel" name="phone" value="<?php echo htmlspecialchars($editData['phone'] ?? ''); ?>">
                        </div>
                        <?php endif; ?>
                        
                        <div class="form-group">
                            <label>Nueva Contraseña (dejar vacío para no cambiar)</label>
                            <input type="password" name="password" placeholder="Si la dejas vacía, no se cambiará">
                        </div>
                        
                        <button type="submit" style="background: #2ecc71;">
                            ✅ Guardar Cambios
                        </button>
                    </form>
                <?php else: ?>
                    <div class="no-selection">
                        <p style="font-size: 24px; margin-bottom: 10px;">👉</p>
                        <p>Selecciona un <?php echo $selectedType === 'users' ? 'usuario' : 'operador'; ?> de la lista para editar</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        function switchTab(type) {
            window.location.href = '?type=' + type;
        }
        
        function selectUser(type, id) {
            window.location.href = '?type=' + type + '&id=' + id;
        }
        
        // Auto-hide messages after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            var msg = document.querySelector('.message.show');
            if (msg) {
                setTimeout(function() {
                    msg.style.display = 'none';
                }, 5000);
            }
        });
    </script>
</body>
</html>
