<?php
require_once 'config.php';

// Solo admin puede ver logs
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'operator') {
    die('Acceso denegado');
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>Logs del Sistema</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #1e1e1e; color: #00ff00; }
        pre { white-space: pre-wrap; line-height: 1.5; }
        .error { color: #ff6b6b; }
        .warning { color: #ffd93d; }
        .info { color: #6bcfff; }
    </style>
</head>
<body>
    <h1>Últimas 100 líneas del error log de PHP</h1>
    <pre><?php
    $logFile = ini_get('error_log');
    if ($logFile && file_exists($logFile)) {
        $lines = file($logFile);
        $last100 = array_slice($lines, -100);
        foreach ($last100 as $line) {
            if (strpos($line, 'ERROR') !== false) {
                echo '<span class="error">' . htmlspecialchars($line) . '</span>';
            } elseif (strpos($line, 'WARNING') !== false) {
                echo '<span class="warning">' . htmlspecialchars($line) . '</span>';
            } else {
                echo '<span class="info">' . htmlspecialchars($line) . '</span>';
            }
        }
    } else {
        echo "No se encontró el archivo de log o error_log no está configurado.\n";
        echo "error_log configurado en: " . ($logFile ?: 'No configurado');
    }
    ?></pre>
    
    <hr>
    <a href="dashboard.php" style="color: #00ff00;">← Volver al Dashboard</a>
</body>
</html>
